<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getOrderDataUsePageByParams(array $params)
 * @method returnSupportOrderByParams(array $params)
 * @method changeStageByParams(array $params)
 * @method getOrderPendingStatusWithCountByParams(array $params)
 * @method getTodayWaitLookingCountByParams(array $params)
 * @method receptionistSignInByParams(array $params)
 * @method giveOrderToStaffByParams(array $params)
 * @method changeOrderToSelectPhotoByParams(array $params)
 * @method turnToLookingPhotoWhenChangeStoreByParams(array $params)
 * @method cameramanCompleteOrderByParams(array $params)
 * @method dresserCompleteOrderByParams(array $params)
 * @method returnToMakeUpByParams(array $params)
 * @method finishSelectPhotoByParams(array $params)
 * @method giveOrderToStaffByDingDingByParams(array $params)
 * @method clearAllNoPaperInfoByParams(array $params)
 * @method wsTakeOrderByParams(array $params)
 * @method changeToWaitingByParams(array $params)
 * @method getStaffProcessTimeByOrderIdsByParams(array $params)
 * @method getLastDresserByParams(array $params)
 * @method getPendingOrderIdsByParams(array $params)
 * @method pushSignInQueueOrderIntoWaitingByParams(array $params)
 * @method staffIsProcessingByParams(array $params)
 * @method getProcessingStaffsByOrderIdByParams(array $params)
 * @method getStaffsByOrderIdWithDelByParams(array $params)
 * @method hangOrderByParams(array $params)
 * @method removeHangOrderByParams(array $params)
 * @method adjustQueueSortByParams(array $params)
 * @method queueIsEmptyWithoutHangAndAssignedOrderByParams(array $params)
 * @method assignOrderToStaffByParams(array $params)
 * @method removeAssignOrderToStaffByParams(array $params)
 * @method getCurrentProcessingStaffByParams(array $params)
 * @method returnToWaitByParams(array $params)
 * @method orderAgainByParams(array $params)
 * @method getProcessStaffByParams(array $params)
 * @method secondRetoucherSignInByParams(array $params)
 * @method getTodayShootingOrderIdsByParams(array $params)
 * @method getPhotographyMakeUpTimeByParams(array $params)
 * @method getOrderEffectiveItemsByParams(array $params)
 * @method clearUnfinishedOrderNoPaperInfoByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单查询
     *
     * @support  array $ids 订单id数组 
     * @support  int $store_id 门店id 
     * @support  string $user_phone 电话 
     * @support  string $user_name 用户姓名 
     * @support  array $online_order_ids 在线订单id数组 
     * @support  string $online_start_at 开始时间 
     * @support  string $online_end_at 结束时间 
     * @support  int $online_order_id 订单id 
     * @support  int $online_staff_id 伙伴id 
     * @support  int $online_store_id 门店id 
     * @support  int $online_divider_id 分配者id 
     * @support  string $online_is_complete 是否完成 
     * @support  bool $online_is_master 是否是主接单人 
     * @support  bool $online_with_order 是否带上order数据 
     * @support  string $online_source 来源 
     * @support  string $online_staff_type 伙伴类型 
     * @support  bool $with_records 带record记录 
     * @support  bool $with_onlines 带online记录 
     * @support  int $record_where_staff_id record staff_id 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单列表
     *
     * @support  array $store_ids 门店id 
     * @support  array $pending_status_arr 无纸化状态 
     * @support  array $ids 订单ids 
     * @support  string $reserve_start_at 预约开始时间 
     * @support  string $reserve_end_at 预约结束时间 
     * @support  string $module 属于哪个模块 
     * @support  bool $use_today_shooting_sort 是否使用当日拍摄的排序 
     * @support  int $page 当前的页数 [Original type uint] 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDataUsePage () {
        return self::getClass()->getOrderDataUsePage();
    }

    /**
     * 退回辅助订单
     *
     * @support  int $orderId 订单id 
     * @support  int $staffId 员工id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnSupportOrder () {
        return self::getClass()->returnSupportOrder();
    }

    /**
     * 将订单改变至待看片审核/看片审核中状态
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $pending_status pending_status [ require true ]
     * @support  int $staff_id 伙伴id 
     * @throws  \Exception
     * @return  array
     */
    public static function changeStage () {
        return self::getClass()->changeStage();
    }

    /**
     * 获取门店拍历史摄数量
     *
     * @support  int $store_id 门店ID 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPendingStatusWithCount () {
        return self::getClass()->getOrderPendingStatusWithCount();
    }

    /**
     * 获取门店当日看片数量
     *
     * @support  int $store_id 门店ID 
     * @throws  \Exception
     * @return  int
     */
    public static function getTodayWaitLookingCount () {
        return self::getClass()->getTodayWaitLookingCount();
    }

    /**
     * 前台签到排队
     *
     * @support  int $order_id 订单id 
     * @support  int $staff_id 员工id 
     * @support  string $pending_status 无纸化状态 
     * @support  int $dresser_id 指定的化妆师id 
     * @support  int $cameraman_id 指定的摄影师id 
     * @support  bool $skip_make_up 是否跳过化妆 
     * @throws  \Exception
     * @return  mixed
     */
    public static function receptionistSignIn () {
        return self::getClass()->receptionistSignIn();
    }

    /**
     * 把订单指派给化妆师或者摄影师
     *
     * @support  int $order_id 订单id 
     * @support  string $pending_status 队列无纸化状态 
     * @support  int $staff_id 伙伴id 
     * @support  string $source 来源 
     * @throws  \Exception
     * @return  array
     */
    public static function giveOrderToStaff () {
        return self::getClass()->giveOrderToStaff();
    }

    /**
     * 把订单改成选片中状态
     *
     * @support  int $order_id 订单id 
     * @support  int $staff_id 伙伴id 
     * @throws  \Exception
     * @return  array
     */
    public static function changeOrderToSelectPhoto () {
        return self::getClass()->changeOrderToSelectPhoto();
    }

    /**
     * 转门店看片指派
     *
     * @support  int $store_id 转门店的门店id [ require true ]
     * @support  int $staff_id 指派伙伴id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function turnToLookingPhotoWhenChangeStore () {
        return self::getClass()->turnToLookingPhotoWhenChangeStore();
    }

    /**
     * 摄影师完成订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cameramanCompleteOrder () {
        return self::getClass()->cameramanCompleteOrder();
    }

    /**
     * 化妆师完成订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $staff_id 伙伴工号 [ require true ]
     * @support  string $remark 备注 
     * @support  int $make_up_num 化妆人数 
     * @throws  \Exception
     * @return  array
     */
    public static function dresserCompleteOrder () {
        return self::getClass()->dresserCompleteOrder();
    }

    /**
     * 摄影师退回化妆
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $make_up_staff_id 上一个化妆师的id [ require true ]
     * @support  int $photographer_staff_id 摄影师id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToMakeUp () {
        return self::getClass()->returnToMakeUp();
    }

    /**
     * 完成选片
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishSelectPhoto () {
        return self::getClass()->finishSelectPhoto();
    }

    /**
     * 分配订单给辅助化妆师
     *
     * @support  array $to_staff_map 伙伴信息 [ require true ]
     * @support  int $order_id 伙伴类型 [ require true ]
     * @support  int $staff_id 分配者id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveOrderToStaffByDingDing () {
        return self::getClass()->giveOrderToStaffByDingDing();
    }

    /**
     * 清除所有无纸化相关的东西
     *
     * @support  int $order_id order_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearAllNoPaperInfo () {
        return self::getClass()->clearAllNoPaperInfo();
    }

    /**
     * 伙伴自动接单
     *
     * @support  int $taker 接单伙伴id [ require true ]
     * @support  int $store_id 门店iod [ require true ]
     * @support  string $pending_status pending_status [ require true ]
     * @support  array $product_ids 通关产品 
     * @support  bool $skip_product_check 跳过通关检查 
     * @support  bool $is_no_paper_pilot 是否新门店 
     * @support  bool $is_dresser_complete_first 是否主化妆师先完成 
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  array
     */
    public static function wsTakeOrder () {
        return self::getClass()->wsTakeOrder();
    }

    /**
     * 排队签到进入等待队列
     *
     * @throws  \Exception
     * @return  array
     */
    public static function changeToWaiting () {
        return self::getClass()->changeToWaiting();
    }

    /**
     * 获取各个伙伴无纸化流程处理时间
     *
     * @support  array $order_ids 订单ids 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffProcessTimeByOrderIds () {
        return self::getClass()->getStaffProcessTimeByOrderIds();
    }

    /**
     * 获取上一个化妆师
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  array
     */
    public static function getLastDresser () {
        return self::getClass()->getLastDresser();
    }

    /**
     * 获取走非无纸化流程的订单
     *
     * @support  array $store_ids 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPendingOrderIds () {
        return self::getClass()->getPendingOrderIds();
    }

    /**
     * 签到排队订单进入等待
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  string $pending_status pending_status [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushSignInQueueOrderIntoWaiting () {
        return self::getClass()->pushSignInQueueOrderIntoWaiting();
    }

    /**
     * 伙伴手头是否有处理中的订单(包含辅助订单)
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  string $staff_type 伙伴类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffIsProcessing () {
        return self::getClass()->staffIsProcessing();
    }

    /**
     * 获取正在处理这个订单的化妆师、摄影师
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessingStaffsByOrderId () {
        return self::getClass()->getProcessingStaffsByOrderId();
    }

    /**
     * 获取所有处理这个订单的化妆师、摄影师(含删除)
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffsByOrderIdWithDel () {
        return self::getClass()->getStaffsByOrderIdWithDel();
    }

    /**
     * 挂起订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function hangOrder () {
        return self::getClass()->hangOrder();
    }

    /**
     * 解除等待排队挂起
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function removeHangOrder () {
        return self::getClass()->removeHangOrder();
    }

    /**
     * 调整等待中的订单排序
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustQueueSort () {
        return self::getClass()->adjustQueueSort();
    }

    /**
     * 等待队列除去挂起状态外是否为空
     *
     * @support  string $pending_status 类型 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueIsEmptyWithoutHangAndAssignedOrder () {
        return self::getClass()->queueIsEmptyWithoutHangAndAssignedOrder();
    }

    /**
     * 指定接单的化妆师或者摄影师
     *
     * @support  int $order_id 订单id 
     * @support  int $dresser_id 化妆师id 
     * @support  int $cameraman_id 摄影师id 
     * @support  int $second_retoucher_id 看片师id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignOrderToStaff () {
        return self::getClass()->assignOrderToStaff();
    }

    /**
     * 移除指定的化妆师或者摄影师
     *
     * @support  int $order_id 订单id 
     * @support  string $staff_type 伙伴类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeAssignOrderToStaff () {
        return self::getClass()->removeAssignOrderToStaff();
    }

    /**
     * 获取当前处理中的伙伴
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentProcessingStaff () {
        return self::getClass()->getCurrentProcessingStaff();
    }

    /**
     * 退回等待队列
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToWait () {
        return self::getClass()->returnToWait();
    }

    /**
     * 化妆/摄影/看片师再来一单
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  string $staff_type 伙伴类型 [ require true ]
     * @support  array $product_ids 伙伴通关产品id 
     * @support  bool $skip_product_check 跳过通关检查 
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAgain () {
        return self::getClass()->orderAgain();
    }

    /**
     * 获取流程中的完成订单的伙伴
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessStaff () {
        return self::getClass()->getProcessStaff();
    }

    /**
     * 看片签到排队
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $pending_status 无纸化状态 
     * @support  int $second_retoucher_id 指定的看片师id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function secondRetoucherSignIn () {
        return self::getClass()->secondRetoucherSignIn();
    }

    /**
     * 获取当日拍摄订单id
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayShootingOrderIds () {
        return self::getClass()->getTodayShootingOrderIds();
    }

    /**
     * 获取当日拍摄订单id
     *
     * @support  array $dresser_ids 化妆师id 
     * @support  array $cameraman_ids 摄影师id 
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographyMakeUpTime () {
        return self::getClass()->getPhotographyMakeUpTime();
    }

    /**
     * 获取订单有效的items
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderEffectiveItems () {
        return self::getClass()->getOrderEffectiveItems();
    }

    /**
     * 清理当天未完成的订单无纸化信息
     *
     * @support  array $order_id_not_in 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearUnfinishedOrderNoPaperInfo () {
        return self::getClass()->clearUnfinishedOrderNoPaperInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}