<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method getListByRefundIdsByParams(array $params)
 */
class RefundChange {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转退列表
     *
     * @support  int $orderId 主订单ID 
     * @support  int $userId 用户ID 
     * @support  string $status 状态 
     * @support  int $page  
     * @support  int $pageSize  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 转退详情
     *
     * @param  int $id 转退ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 创建转退
     *
     * @support  int $refundId  [ require true ]
     * @support  string $people  [ require true ]
     * @support  string $account  [ require true ]
     * @support  string $reason  [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 删除转退
     *
     * @param  int $id 转退ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 通过转退
     *
     * @param  int $id 转退ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pass (int $id) {
        return self::getClass()->pass([
            "id" => $id,
        ]);
    }

    /**
     * 拒绝转退
     *
     * @param  int $id 转退ID [ require true ]
     * @param  string $reason 拒绝原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reject (int $id, string $reason = NULL) {
        return self::getClass()->reject([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 批量获取转退列表
     *
     * @param  array $refund_ids 退款ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByRefundIds (array $refund_ids) {
        return self::getClass()->getListByRefundIds([
            "refund_ids" => $refund_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'RefundChange');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'RefundChange');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}