<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method createByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method removeByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method allIncomeItemsByParams(array $params)
 */
class OfflineOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $status 状态 
     * @support  int $store_id 门店ID 
     * @support  string $paid_at_start 支付时间起始 
     * @support  string $paid_at_end 支付时间结束 
     * @support  int $page  
     * @support  int $page_size  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 订单详情
     *
     * @param  int $id 线下订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情【根据订单号获取】
     *
     * @param  string $order_no 线下订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByNo (string $order_no) {
        return self::getClass()->detailByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 创建订单
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  int $incomeItemId 线下收入项目ID [ require true ]
     * @support  int $amount 数量 [ require true ]
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $order_no) {
        return self::getClass()->getIdByNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 移除订单
     *
     * @param  int $id 线下订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id 线下订单ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, string $payType, string $paymentNo = NULL) {
        return self::getClass()->setPaid([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 全部收入项目
     *
     * @param  bool $withHidden 是否包含隐藏的收入项 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allIncomeItems (bool $withHidden = false) {
        return self::getClass()->allIncomeItems([
            "withHidden" => $withHidden,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OfflineOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OfflineOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}