<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getListByOrderIdByParams(array $params)
 * @method inputByStoreByParams(array $params)
 * @method resetByParams(array $params)
 * @method inputKpsWorkloadByParams(array $params)
 */
class Workload {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 工作量列表
     *
     * @support  array $orderIds 订单ID数组 
     * @support  int $staffId 员工工号 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $staffType 伙伴岗位类型 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 根据订单ID查询该订单的工作量列表
     *
     * @param  int $order_id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByOrderId (int $order_id) {
        return self::getClass()->getListByOrderId([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 门店录入工作量
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputByStore (int $orderId, array $workloads) {
        return self::getClass()->inputByStore([
            "orderId" => $orderId,
            "workloads" => $workloads,
        ]);
    }

    /**
     * 该接口清空工作量
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reset (int $orderId, array $workloads) {
        return self::getClass()->reset([
            "orderId" => $orderId,
            "workloads" => $workloads,
        ]);
    }

    /**
     * 该接口只录入看片师工作量
     * TODO 该接口可能被移除或替换
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $staffId 伙伴ID [ require true ]
     * @param  int $workPer 工作量占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputKpsWorkload (int $orderId, int $staffId, int $workPer) {
        return self::getClass()->inputKpsWorkload([
            "orderId" => $orderId,
            "staffId" => $staffId,
            "workPer" => $workPer,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Workload');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Workload');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}