<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchUseDbByParams(array $params)
 * @method searchUseEsByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByOrderNoByParams(array $params)
 * @method createByParams(array $params)
 * @method submitByParams(array $params)
 * @method removeByParams(array $params)
 * @method cancelByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method finishByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method changeExtendByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method recoverFinishedToWaitShootingByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method deleteByUserByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 使用数据库查询订单
     *
     * @support  array $order_ids 订单编号s 
     * @support  array $order_nos 订单ids 
     * @support  array $store_ids 门店ids 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  string $create_time_start 查询开始时间 
     * @support  string $create_time_end 查询结束时间 
     * @support  array $user_ids 绑定用户uids 
     * @support  string $status 订单状态 
     * @support  array $status_list 订单状态 
     * @support  string $pending_status 无纸化状态 
     * @support  array $pending_status_list 无纸化状态数组 
     * @support  string $user_name 下单用户 
     * @support  string $module 模块 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  string $sort_field 排序字段 
     * @support  bool $sort_desc 是否倒序 
     * @support  bool $with_del 是否需要删除数据 
     * @throws  \Exception
     * @return  array
     */
    public static function searchUseDb () {
        return self::getClass()->searchUseDb();
    }

    /**
     * searchUseEs
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUseEs () {
        return self::getClass()->searchUseEs();
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情【根据订单号获取】
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByOrderNo (string $order_no) {
        return self::getClass()->detailByOrderNo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 订单概念分主订单和子订单，主订单下面包含多个子订单，子订单分一销子订单和二销子订单。
     * 一销子订单不可以直接创建，主订单创建接口，隐含了对一销子订单的创建，因此在一个主订单下面，有且只有一条一销子订单。
     * 二销子订单可以有无限条，通过子订单创建接口直接创建
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $userId 用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户行吧 
     * @support  string $userBirthday 用户生日 
     * @support  string $from 订单来源（管理端、预约端） [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  int $globalDiscountId 全局优惠ID 
     * @support  float $globalDiscountMoney 全局优惠金额 [Original type double] 
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $giftCardMoney 礼品卡金额 [Original type double] 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $occupyNum 派单表占点数量 [ require true ]
     * @support  string $module 订单模块（himo，mantu） 
     * @support  string $type 订单类型（参考OrderTypeEnum） [ require true ]
     * @support  array $extend 订单extend 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, string $payType, string $paymentNo = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function finish (int $id) {
        return self::getClass()->finish([
            "id" => $id,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTime (int $id, string $reserveTime) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData();
    }

    /**
     * 修改订单extend数据
     *
     * @support  string $note 订单备注 
     * @support  string $no_paper_note 无纸化备注 
     * @throws  \Exception
     * @return  array
     */
    public static function changeExtend () {
        return self::getClass()->changeExtend();
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 把完成的订单恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverFinishedToWaitShooting (int $id) {
        return self::getClass()->recoverFinishedToWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $orderNo) {
        return self::getClass()->getIdByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 转换门店
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeStore (int $id, int $storeId) {
        return self::getClass()->changeStore([
            "id" => $id,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @param  bool $force 强制绑定 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $userId, bool $force = false) {
        return self::getClass()->bindUser([
            "id" => $id,
            "userId" => $userId,
            "force" => $force,
        ]);
    }

    /**
     * 解绑用户
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 用户删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteByUser (int $id) {
        return self::getClass()->deleteByUser([
            "id" => $id,
        ]);
    }

    /**
     * TODO 该接口暂时没有过滤掉加修加印等不需要云端上传照片的服务
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrder (string $orderNo = NULL, int $orderId = NULL) {
        return self::getClass()->getProductsInOrder([
            "orderNo" => $orderNo,
            "orderId" => $orderId,
        ]);
    }

    /**
     * TODO 该接口暂时没有过滤掉加修加印等不需要云端上传照片的服务
     *
     * @param  array $orderNos 订单号数组 [ require true ]
     * @param  array $orderIds 订单ID数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrders (array $orderNos = NULL, array $orderIds = NULL) {
        return self::getClass()->getProductsInOrders([
            "orderNos" => $orderNos,
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoice_id 发票ID [ require true ]
     * @param  array $order_nos 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoice_id, array $order_nos) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoice_id" => $invoice_id,
            "order_nos" => $order_nos,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}