<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 */
class OrderStateRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取最后一条队列的排序号
     *
     * @support  string $pending_status 状态 
     * @support  int $order_id order_id 
     * @support  array $order_ids order_ids 
     * @support  int $online_id online_id 
     * @support  int $staff_id staff_id 
     * @support  array $staff_ids staff_ids 
     * @support  array $pending_status_in pending_status_in 
     * @support  bool $time_null 是否时间为null 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取最后一条队列的排序号（慎用）
     *
     * @support  string $pending_status 状态 
     * @support  int $order_id order_id 
     * @support  array $order_ids order_ids 
     * @support  int $online_id online_id 
     * @support  int $staff_id staff_id 
     * @support  array $staff_ids staff_ids 
     * @support  array $pending_status_in pending_status_in 
     * @support  bool $time_null 是否时间为null 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderStateRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderStateRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}