<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 */
class OrderOnline {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 在线订单查询
     *
     * @support  string $start_at 开始时间 
     * @support  array $order_ids 订单id数组 
     * @support  string $end_at 结束时间 
     * @support  int $order_id 订单id 
     * @support  int $staff_id 伙伴id 
     * @support  int $store_id 门店id 
     * @support  int $divider_id 分配者id 
     * @support  string $is_complete 是否完成 
     * @support  bool $is_master 是否是主接单人 
     * @support  bool $with_order 是否带上order数据 
     * @support  string $source 来源 
     * @support  string $staff_type 伙伴类型 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 在线订单查询，不带分页（慎用）
     *
     * @support  array $order_ids 订单id数组 
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  int $order_id 订单id 
     * @support  int $staff_id 伙伴id 
     * @support  int $store_id 门店id 
     * @support  int $divider_id 分配者id 
     * @support  string $is_complete 是否完成 
     * @support  bool $is_master 是否是主接单人 
     * @support  bool $with_order 是否带上order数据 
     * @support  string $source 来源 
     * @support  string $staff_type 伙伴类型 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderOnline');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderOnline');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}