<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindOrderByParams(array $params)
 * @method sendCodeByParams(array $params)
 * @method searchQueueCountByParams(array $params)
 * @method returnSupportOrderByParams(array $params)
 * @method receptionistSignInByParams(array $params)
 * @method giveOrderToStaffByParams(array $params)
 * @method cameramanCompleteOrderByParams(array $params)
 * @method dresserCompleteOrderByParams(array $params)
 * @method returnToMakeUpByParams(array $params)
 * @method finishSelectPhotoByParams(array $params)
 * @method getCurrentWorkingOrdersByParams(array $params)
 * @method giveOrderToStaffByDingDingByParams(array $params)
 * @method clearAllNoPaperInfoByParams(array $params)
 * @method wsTakeOrderByParams(array $params)
 * @method changeToWaitingByParams(array $params)
 * @method getStaffProcessTimeByOrderIdsByParams(array $params)
 * @method getLastDresserByParams(array $params)
 * @method getPendingOrderIdsByParams(array $params)
 * @method pushSignInQueueOrderIntoWaitingByParams(array $params)
 * @method staffIsProcessingByParams(array $params)
 * @method getProcessingStaffsByOrderIdByParams(array $params)
 * @method hangOrderByParams(array $params)
 * @method removeHangOrderByParams(array $params)
 * @method adjustQueueSortByParams(array $params)
 * @method queueIsEmptyWithoutHangAndAssignedOrderByParams(array $params)
 * @method assignOrderToStaffByParams(array $params)
 * @method removeAssignOrderToStaffByParams(array $params)
 * @method getOrderDresserAndCameramenByParams(array $params)
 * @method getCurrentProcessingStaffByParams(array $params)
 * @method returnToWaitByParams(array $params)
 * @method orderAgainByParams(array $params)
 * @method getProcessStaffByParams(array $params)
 * @method secondRetoucherSignInByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [管]绑定订单
     *
     * @param  int $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $code) {
        return self::getClass()->bindOrder([
            "code" => $code,
        ]);
    }

    /**
     * 订单绑定发送验证码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCode (string $phone, string $order_num) {
        return self::getClass()->sendCode([
            "phone" => $phone,
            "order_num" => $order_num,
        ]);
    }

    /**
     * 搜索队列数量
     *
     * @support  string $pending_status 类型 
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  int
     */
    public static function searchQueueCount () {
        return self::getClass()->searchQueueCount();
    }

    /**
     * 退回辅助订单
     *
     * @support  int $orderId 订单id 
     * @support  int $staffId 员工id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnSupportOrder () {
        return self::getClass()->returnSupportOrder();
    }

    /**
     * 前台签到排队
     *
     * @support  int $order_id 订单id 
     * @support  int $staff_id 员工id 
     * @support  string $pending_status 无纸化状态 
     * @support  int $dresser_id 指定的化妆师id 
     * @support  int $cameraman_id 指定的摄影师id 
     * @support  bool $skip_make_up 是否跳过化妆 
     * @throws  \Exception
     * @return  mixed
     */
    public static function receptionistSignIn () {
        return self::getClass()->receptionistSignIn();
    }

    /**
     * 把订单指派给化妆师或者摄影师
     *
     * @support  int $order_id 订单id 
     * @support  string $pending_status 队列无纸化状态 
     * @support  int $staff_id 伙伴id 
     * @support  string $source 来源 
     * @throws  \Exception
     * @return  array
     */
    public static function giveOrderToStaff () {
        return self::getClass()->giveOrderToStaff();
    }

    /**
     * 摄影师完成订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $staff_id 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cameramanCompleteOrder () {
        return self::getClass()->cameramanCompleteOrder();
    }

    /**
     * 化妆师完成订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $staff_id 伙伴工号 [ require true ]
     * @support  string $remark 备注 
     * @support  int $make_up_num 化妆人数 
     * @throws  \Exception
     * @return  array
     */
    public static function dresserCompleteOrder () {
        return self::getClass()->dresserCompleteOrder();
    }

    /**
     * 摄影师退回化妆
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $make_up_staff_id 上一个化妆师的id [ require true ]
     * @support  int $photographer_staff_id 摄影师id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToMakeUp () {
        return self::getClass()->returnToMakeUp();
    }

    /**
     * 完成选片
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishSelectPhoto () {
        return self::getClass()->finishSelectPhoto();
    }

    /**
     * 获取伙伴当前的主单
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentWorkingOrders () {
        return self::getClass()->getCurrentWorkingOrders();
    }

    /**
     * 分配订单给辅助化妆师
     *
     * @support  array $to_staff_ids 伙伴ids [ require true ]
     * @support  int $order_id 伙伴类型 [ require true ]
     * @support  int $staff_id 分配者id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveOrderToStaffByDingDing () {
        return self::getClass()->giveOrderToStaffByDingDing();
    }

    /**
     * 清除所有无纸化相关的东西
     *
     * @support  int $order_id order_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearAllNoPaperInfo () {
        return self::getClass()->clearAllNoPaperInfo();
    }

    /**
     * 伙伴自动接单
     *
     * @support  int $taker 接单伙伴id [ require true ]
     * @support  int $store_id 门店iod [ require true ]
     * @support  string $pending_status pending_status [ require true ]
     * @support  array $product_ids 通关产品 [ require true ]
     * @support  bool $skip_product_check 跳过通关检查 
     * @throws  \Exception
     * @return  array
     */
    public static function wsTakeOrder () {
        return self::getClass()->wsTakeOrder();
    }

    /**
     * 排队签到进入等待队列
     *
     * @throws  \Exception
     * @return  array
     */
    public static function changeToWaiting () {
        return self::getClass()->changeToWaiting();
    }

    /**
     * 获取各个伙伴无纸化流程处理时间
     *
     * @support  array $order_ids 订单ids 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffProcessTimeByOrderIds () {
        return self::getClass()->getStaffProcessTimeByOrderIds();
    }

    /**
     * 获取上一个化妆师
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  array
     */
    public static function getLastDresser () {
        return self::getClass()->getLastDresser();
    }

    /**
     * 获取走非无纸化流程的订单
     *
     * @support  array $store_ids 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPendingOrderIds () {
        return self::getClass()->getPendingOrderIds();
    }

    /**
     * 签到排队订单进入等待化妆
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  string $pending_status pending_status [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushSignInQueueOrderIntoWaiting () {
        return self::getClass()->pushSignInQueueOrderIntoWaiting();
    }

    /**
     * 伙伴手头是否有处理中的订单(包含辅助订单)
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffIsProcessing () {
        return self::getClass()->staffIsProcessing();
    }

    /**
     * 获取正在处理这个订单的化妆师、摄影师
     *
     * @support  int $order_id order id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessingStaffsByOrderId () {
        return self::getClass()->getProcessingStaffsByOrderId();
    }

    /**
     * 挂起订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function hangOrder () {
        return self::getClass()->hangOrder();
    }

    /**
     * 解除等待排队挂起
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function removeHangOrder () {
        return self::getClass()->removeHangOrder();
    }

    /**
     * 调整等待中的订单排序
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustQueueSort () {
        return self::getClass()->adjustQueueSort();
    }

    /**
     * 等待队列除去挂起状态外是否为空
     *
     * @support  string $pending_status 类型 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueIsEmptyWithoutHangAndAssignedOrder () {
        return self::getClass()->queueIsEmptyWithoutHangAndAssignedOrder();
    }

    /**
     * 指定接单的化妆师或者摄影师
     *
     * @support  int $order_id 订单id 
     * @support  int $dresser_id 化妆师id 
     * @support  int $cameraman_id 摄影师id 
     * @support  int $second_retoucher 看片师id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignOrderToStaff () {
        return self::getClass()->assignOrderToStaff();
    }

    /**
     * 移除指定的化妆师或者摄影师
     *
     * @support  int $order_id 订单id 
     * @support  string $staff_type 伙伴类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeAssignOrderToStaff () {
        return self::getClass()->removeAssignOrderToStaff();
    }

    /**
     * 指定接单的化妆师或者摄影师
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDresserAndCameramen () {
        return self::getClass()->getOrderDresserAndCameramen();
    }

    /**
     * 获取当前处理中的伙伴
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentProcessingStaff () {
        return self::getClass()->getCurrentProcessingStaff();
    }

    /**
     * 退回等待队列
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToWait () {
        return self::getClass()->returnToWait();
    }

    /**
     * 再来一单
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  array $product_ids 伙伴通关产品id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAgain () {
        return self::getClass()->orderAgain();
    }

    /**
     * 获取流程中的完成订单的伙伴
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessStaff () {
        return self::getClass()->getProcessStaff();
    }

    /**
     * 看片签到排队
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $staff_id 前台id 
     * @support  string $pending_status 无纸化状态 
     * @support  int $second_retoucher_id 指定的看片师id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function secondRetoucherSignIn () {
        return self::getClass()->secondRetoucherSignIn();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}