<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method reapplyByParams(array $params)
 * @method reasonOptionsByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款列表
     *
     * @support  int $orderId 主订单ID 
     * @support  string $status 状态 
     * @support  int $storeId 门店ID 
     * @support  string $applyTimeStart 申请时间-开始 
     * @support  string $applyTimeEnd 申请时间-结束 
     * @support  string $processTimeStart 处理时间-开始 
     * @support  string $processTimeEnd 处理时间-结束 
     * @support  int $page  
     * @support  int $pageSize  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款详情
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 创建退款
     *
     * @support  int $subOrderId 子订单号 [ require true ]
     * @support  int $scale 比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  string $reason 原因 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @support  string $from 来源，用户预约端申请，后台申请 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 删除退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pass (int $id) {
        return self::getClass()->pass([
            "id" => $id,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $reason 退款原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reject (int $id, string $reason = NULL) {
        return self::getClass()->reject([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 重新申请退款
     *
     * @support  int $id 退款ID [ require true ]
     * @support  int $scale 比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @throws  \Exception
     * @return  array
     */
    public static function reapply () {
        return self::getClass()->reapply();
    }

    /**
     * 退款原因选项
     *
     * @param  string $category 分类：category_user_refund,category_admin_refund [ require true ]
     * @param  int $parentId  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reasonOptions (string $category, int $parentId = 0) {
        return self::getClass()->reasonOptions([
            "category" => $category,
            "parentId" => $parentId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}