<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchUseDbByParams(array $params)
 * @method searchUseEsByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method submitByParams(array $params)
 * @method removeByParams(array $params)
 * @method cancelByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method finishByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method deleteByUserByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 使用数据库查询订单
     *
     * @support  array $order_ids 订单编号s 
     * @support  array $order_nos 订单ids 
     * @support  array $store_ids 门店ids 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  string $create_time_start 查询开始时间 
     * @support  string $create_time_end 查询结束时间 
     * @support  array $user_ids 绑定用户uids 
     * @support  array $status 订单状态s 
     * @support  string $user_name 下单用户 
     * @support  string $module 模块 
     * @support  array $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  string $sort_field 排序字段 
     * @support  bool $sort_desc 是否倒序 
     * @support  bool $with_del 是否需要删除数据 
     * @throws  \Exception
     * @return  array
     */
    public static function searchUseDb () {
        return self::getClass()->searchUseDb();
    }

    /**
     * searchUseEs
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUseEs () {
        return self::getClass()->searchUseEs();
    }

    /**
     * 订单详情
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单概念分主订单和子订单，主订单下面包含多个子订单，子订单分一销子订单和二销子订单。
     * 一销子订单不可以直接创建，主订单创建接口，隐含了对一销子订单的创建，因此在一个主订单下面，有且只有一条一销子订单。
     * 二销子订单可以有无限条，通过子订单创建接口直接创建
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $userId  
     * @support  string $userName  
     * @support  string $userPhone  
     * @support  string $from  [ require true ]
     * @support  float $money  [Original type double] [ require true ]
     * @support  array $detail  [ require true ]
     * @support  int $couponId  
     * @support  float $giftCardMoney  [Original type double] 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $occupyNum 派单表占点数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 提交订单
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id  [ require true ]
     * @param  string $reason  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id  [ require true ]
     * @param  string $payType  [ require true ]
     * @param  string $paymentNo  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, string $payType, string $paymentNo = NULL) {
        return self::getClass()->setPaid([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id  [ require true ]
     * @param  string $reason  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成订单
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function finish (int $id) {
        return self::getClass()->finish([
            "id" => $id,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id  [ require true ]
     * @param  string $reserveTime  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTime (int $id, string $reserveTime) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id  [ require true ]
     * @support  string $userName  [ require true ]
     * @support  string $userPhone  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData();
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $orderNo  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $orderNo) {
        return self::getClass()->getIdByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 转换门店
     *
     * @param  int $id  [ require true ]
     * @param  int $storeId  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeStore (int $id, int $storeId) {
        return self::getClass()->changeStore([
            "id" => $id,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 绑定用户
     *
     * @param  int $id  [ require true ]
     * @param  int $userId  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $userId) {
        return self::getClass()->bindUser([
            "id" => $id,
            "userId" => $userId,
        ]);
    }

    /**
     * 解绑用户
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 用户删除订单
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteByUser (int $id) {
        return self::getClass()->deleteByUser([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}