<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method inputByStoreByParams(array $params)
 * @method resetByParams(array $params)
 * @method inputByCloudByParams(array $params)
 */
class Workload {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 工作量列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 门店录入工作量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputByStore () {
        return self::getClass()->inputByStore();
    }

    /**
     * 重置工作量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reset () {
        return self::getClass()->reset();
    }

    /**
     * 云端录入工作量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputByCloud () {
        return self::getClass()->inputByCloud();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Workload');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Workload');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}