<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchUseDbByParams(array $params)
 * @method searchUseEsByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method cancelByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method finishByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method deleteByUserByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * searchUseDb
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUseDb () {
        return self::getClass()->searchUseDb();
    }

    /**
     * searchUseEs
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchUseEs () {
        return self::getClass()->searchUseEs();
    }

    /**
     * 订单详情
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 创建订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 删除订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * 取消订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 设置订单完成支付
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaid () {
        return self::getClass()->setPaid();
    }

    /**
     * 开始订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function start () {
        return self::getClass()->start();
    }

    /**
     * 关闭订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * 完成订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function finish () {
        return self::getClass()->finish();
    }

    /**
     * 修改预约时间
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime () {
        return self::getClass()->changeReserveTime();
    }

    /**
     * 修改用户数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData();
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverWaitShooting () {
        return self::getClass()->recoverWaitShooting();
    }

    /**
     * 根据订单号获取订单ID
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo () {
        return self::getClass()->getIdByNo();
    }

    /**
     * 根据订单ID获取订单号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById () {
        return self::getClass()->getNoById();
    }

    /**
     * 转换门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStore () {
        return self::getClass()->changeStore();
    }

    /**
     * 绑定用户
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindUser () {
        return self::getClass()->bindUser();
    }

    /**
     * 解绑用户
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindUser () {
        return self::getClass()->unbindUser();
    }

    /**
     * 用户删除订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteByUser () {
        return self::getClass()->deleteByUser();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}