<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRefundChangeByParams(array $params)
 * @method queryRefundChangeByParams(array $params)
 * @method handleRefundChangeByParams(array $params)
 * @method deleteRefundChangeByParams(array $params)
 * @method createUserOrderRefundByParams(array $params)
 * @method queryOrderRefundHistoryByParams(array $params)
 * @method orderRefundDetailByParams(array $params)
 * @method createOrderRefundByParams(array $params)
 * @method orderOriginMoneyByParams(array $params)
 * @method getSpecialOrderMoneyByParams(array $params)
 * @method handleSpecialOrderRefundByParams(array $params)
 * @method rejectOrderRefundByParams(array $params)
 * @method processFinanceRefundByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 申请转退
     *
     * @support  int $refundId 退款id [ require true ]
     * @support  int $staffId 操作人id [ require true ]
     * @support  string $refundUsername 退款人用户 [ require true ]
     * @support  string $refundAccount 退款账户 [ require true ]
     * @support  string $refundNote 退款备注 [ require true ]
     * @support  int $isStaff 伙伴是否垫付 1是 0 否 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRefundChange () {
        return self::getClass()->createRefundChange();
    }

    /**
     * 查询转退列表
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $refundStatus 退款状态 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryRefundChange (int $orderId = 0, string $refundStatus = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->queryRefundChange([
            "orderId" => $orderId,
            "refundStatus" => $refundStatus,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 处理转退款申请
     *
     * @param  int $changeId 转退id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleRefundChange (int $changeId) {
        return self::getClass()->handleRefundChange([
            "changeId" => $changeId,
        ]);
    }

    /**
     * 删除转退款申请
     *
     * @param  int $changeId 转退id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteRefundChange (int $changeId) {
        return self::getClass()->deleteRefundChange([
            "changeId" => $changeId,
        ]);
    }

    /**
     * 预约端用户自主申请退款
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $reasonId 退款原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createUserOrderRefund (int $orderId, int $reasonId) {
        return self::getClass()->createUserOrderRefund([
            "orderId" => $orderId,
            "reasonId" => $reasonId,
        ]);
    }

    /**
     * 查询后台退款列表
     *
     * @support  int $timeType 时间筛选类型 1：按照提交时间 2:按照退款时间 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  int $storeId 门店id 
     * @support  int $refundReason 退款理由 
     * @support  int $orderId 订单id 
     * @support  string $refundStatus 退款状态 
     * @support  string $refundType 退款类型 
     * @support  int $isStaffPay 是否伙伴垫付 1：是 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryOrderRefundHistory () {
        return self::getClass()->queryOrderRefundHistory();
    }

    /**
     * 订单退款详情
     *
     * @param  int $refundId 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderRefundDetail (int $refundId) {
        return self::getClass()->orderRefundDetail([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 预约退款录入
     *
     * @support  int $orderId 订单ID 
     * @support  string $refundType 退款类型 [ require true ]
     * @support  int $refundStore 退款门店ID(仅其他退款时有效) 
     * @support  float $refundMoney 退款金额 [Original type double] [ require true ]
     * @support  string $refundPart 退款部分 
     * @support  int $refundGoodsId 其他退款类型需要的商品ID 
     * @support  string $refundContent 退款内容 (只有退款至礼品卡会使用此字段 : all : 全部 order: 初始支付 ds_all: 全部二销，{$ds_sku_id} : ds 产品id) 
     * @support  string $refundPeople 退款人 [ require true ]
     * @support  string $refundAccount 退款账户 [ require true ]
     * @support  int $refundStaffId 退款录入人ID [ require true ]
     * @support  int $refundScale 退款比例 [ require true ]
     * @support  int $refundReason 退款原因 [ require true ]
     * @support  bool $isStaffPay 是否为伙伴垫付 
     * @support  bool $isRefundCard 是否退券 
     * @support  string $refundNote 退款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderRefund () {
        return self::getClass()->createOrderRefund();
    }

    /**
     * 获取订单可退金额
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $retryNum 无需传递 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderOriginMoney (int $orderId, int $retryNum = 0) {
        return self::getClass()->orderOriginMoney([
            "orderId" => $orderId,
            "retryNum" => $retryNum,
        ]);
    }

    /**
     * 获取特殊订单可退金额
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpecialOrderMoney (int $orderId) {
        return self::getClass()->getSpecialOrderMoney([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 0元单退款处理
     * @deprecated
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $reasonId 退款原因 [ require true ]
     * @param  int $refundId 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleSpecialOrderRefund (int $orderId, int $reasonId = 0, int $refundId = 0) {
        return self::getClass()->handleSpecialOrderRefund([
            "orderId" => $orderId,
            "reasonId" => $reasonId,
            "refundId" => $refundId,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $refundId 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rejectOrderRefund (int $refundId) {
        return self::getClass()->rejectOrderRefund([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 处理退款
     *
     * @param  int $refundId 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function processFinanceRefund (int $refundId) {
        return self::getClass()->processFinanceRefund([
            "refundId" => $refundId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}