<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method inputWorkloadByParams(array $params)
 * @method resetWorkloadByParams(array $params)
 * @method searchWorkloadByParams(array $params)
 * @method queryWorkloadWithOrderByParams(array $params)
 * @method writeWorkLoadByCloudByParams(array $params)
 */
class Workload {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入员工工作量
     *
     * @param  array $workLoads 录入的工作量 [ require true ]
     * @param  int $order_id 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputWorkload (array $workLoads, int $order_id) {
        return self::getClass()->inputWorkload([
            "workLoads" => $workLoads,
            "order_id" => $order_id,
        ]);
    }

    /**
     * 重置工作量
     *
     * @param  array $workLoads 工作量数组 [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetWorkload (array $workLoads, int $orderId) {
        return self::getClass()->resetWorkload([
            "workLoads" => $workLoads,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 查询符合条件的所有工作量
     *
     * @param  int $staff_id 员工工号 [Original type uint] [ require true ]
     * @param  string $start_time 开始时间 [ require true ]
     * @param  string $end_time 结束时间 [ require true ]
     * @param  array $order_ids 订单号ids [ require true ]
     * @param  string $staff_type 伙伴岗位类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchWorkload (array $order_ids = [], int $staff_id = 0, string $staff_type = '', string $start_time = '', string $end_time = '') {
        return self::getClass()->searchWorkload([
            "order_ids" => $order_ids,
            "staff_id" => $staff_id,
            "staff_type" => $staff_type,
            "start_time" => $start_time,
            "end_time" => $end_time,
        ]);
    }

    /**
     * 获取员工工作量与对应订单
     *
     * @param  string $staff_type 职位id [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @param  string $start_time 开始时间 [ require true ]
     * @param  string $end_time 结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @param  bool $is_export 是否导出数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryWorkloadWithOrder (string $staff_type, int $staff_id, string $start_time = '', string $end_time = '', int $page = 1, int $page_size = 10, bool $is_export = false) {
        return self::getClass()->queryWorkloadWithOrder([
            "staff_type" => $staff_type,
            "staff_id" => $staff_id,
            "start_time" => $start_time,
            "end_time" => $end_time,
            "page" => $page,
            "page_size" => $page_size,
            "is_export" => $is_export,
        ]);
    }

    /**
     * 云端看片师工作量录入
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  string $staff_type 员工类型 [ require true ]
     * @param  float $work_per 工作量 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function writeWorkLoadByCloud (int $order_id, int $staff_id, string $staff_type, float $work_per) {
        return self::getClass()->writeWorkLoadByCloud([
            "order_id" => $order_id,
            "staff_id" => $staff_id,
            "staff_type" => $staff_type,
            "work_per" => $work_per,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Workload');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Workload');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}