<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOfflineTurnoverByParams(array $params)
 * @method queryOfflineListByParams(array $params)
 * @method getOfflineCertificateByParams(array $params)
 * @method checkOfflineByParams(array $params)
 * @method deleteOfflineByParams(array $params)
 * @method getOfflineGoodsByParams(array $params)
 * @method querySnListByParams(array $params)
 * @method getSnByOrderIdByParams(array $params)
 * @method snDetailByParams(array $params)
 * @method addNpsByParams(array $params)
 * @method checkOrderHasNpsByParams(array $params)
 * @method getOrderNpsByParams(array $params)
 * @method getNoneNpsByParams(array $params)
 * @method getNpsByParams(array $params)
 * @method editNpsByParams(array $params)
 * @method getSnQuestionByParams(array $params)
 * @method submitSnAnswerByParams(array $params)
 * @method storeOrderPerformanceByParams(array $params)
 * @method getOrderOptionByParams(array $params)
 * @method createNewOrderLogByParams(array $params)
 * @method getOrderLogByParams(array $params)
 * @method queryOrderLogByParams(array $params)
 * @method delOrderLogByParams(array $params)
 */
class Tools {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createOfflineTurnover
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  int $operateId 操作人id [ require true ]
     * @param  float $money 金额 [Original type double] [ require true ]
     * @param  int $num 数量 [ require true ]
     * @param  int $sellerId 售出人id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  int $goods_id 收/支商品id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $dutyPerson 收款人 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @param  array $certificates 凭证 [ require true ]
     * @param  string $payTime 支付时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOfflineTurnover (int $storeId, int $operateId, float $money, string $payType, int $goods_id, string $type, string $dutyPerson = '', string $note = '', array $certificates = [], string $payTime = '', int $num = 1, int $sellerId = 0) {
        return self::getClass()->createOfflineTurnover([
            "storeId" => $storeId,
            "operateId" => $operateId,
            "money" => $money,
            "payType" => $payType,
            "goods_id" => $goods_id,
            "type" => $type,
            "dutyPerson" => $dutyPerson,
            "note" => $note,
            "certificates" => $certificates,
            "payTime" => $payTime,
            "num" => $num,
            "sellerId" => $sellerId,
        ]);
    }

    /**
     * queryOfflineList
     *
     * @param  string $type 收/支类型 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  int $goods_id 商品id [ require true ]
     * @param  int $operateId 操作人id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $startTime 查询开始时间 [ require true ]
     * @param  string $endTime 查询结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryOfflineList (string $type, int $storeId = 0, int $goods_id = 0, int $operateId = 0, string $payType = '', string $startTime = '', string $endTime = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->queryOfflineList([
            "type" => $type,
            "storeId" => $storeId,
            "goods_id" => $goods_id,
            "operateId" => $operateId,
            "payType" => $payType,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取线下流水凭证
     *
     * @param  int $offlineId 线下流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOfflineCertificate (int $offlineId) {
        return self::getClass()->getOfflineCertificate([
            "offlineId" => $offlineId,
        ]);
    }

    /**
     * 审核线下支出
     *
     * @param  int $offlineId 线下流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOffline (int $offlineId) {
        return self::getClass()->checkOffline([
            "offlineId" => $offlineId,
        ]);
    }

    /**
     * 线下流水删除
     *
     * @param  int $offlineId 线下流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOffline (int $offlineId) {
        return self::getClass()->deleteOffline([
            "offlineId" => $offlineId,
        ]);
    }

    /**
     * 获取商品列表
     *
     * @param  string $category 查询类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOfflineGoods (string $category = '') {
        return self::getClass()->getOfflineGoods([
            "category" => $category,
        ]);
    }

    /**
     * 查询Sn问卷数据
     *
     * @param  string $storeId 门店id [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function querySnList (string $storeId, string $startTime, string $endTime, int $page = 1, int $pageSize = 15) {
        return self::getClass()->querySnList([
            "storeId" => $storeId,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据order_id获取sn详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSnByOrderId (int $orderId) {
        return self::getClass()->getSnByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取sn详情
     *
     * @param  int $snId sn id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function snDetail (int $snId) {
        return self::getClass()->snDetail([
            "snId" => $snId,
        ]);
    }

    /**
     * 录入Nps信息
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $user_id 用户uid [ require true ]
     * @support  int $nps_all 总评分 [ require true ]
     * @support  int $nps_receptionist 门市客服评分 [ require true ]
     * @support  int $nps_cameraman 摄影师平分 [ require true ]
     * @support  int $nps_dresser 化妆师评分 [ require true ]
     * @support  int $nps_retoucher 看片师评分 [ require true ]
     * @support  string $nps_note 其他反馈 
     * @support  int $is_sn 是否参与sn 
     * @support  int $is_share 是否参与分享 
     * @support  int $is_stat 是否参与统计 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNps () {
        return self::getClass()->addNps();
    }

    /**
     * 获取没有nps的订单
     *
     * @param  array $orderIds 订单id列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkOrderHasNps (array $orderIds) {
        return self::getClass()->checkOrderHasNps([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取某个订单的nps评价
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderNps (int $orderId) {
        return self::getClass()->getOrderNps([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取未评价nps的订单
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNoneNps (int $storeId, string $startTime, string $endTime, int $page = 1, int $pageSize = 15) {
        return self::getClass()->getNoneNps([
            "storeId" => $storeId,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 查询nps评价
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $staffId 伙伴ID [ require true ]
     * @param  array $orderIds 订单IDs [ require true ]
     * @param  string $job 职位 [ require true ]
     * @param  int $score 评分范围 [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  bool $isSn 是否查询sn [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNps (int $storeId = 0, array $orderIds = [], int $staffId = 0, string $job = '', int $score = 0, string $startTime = '', string $endTime = '', int $page = 1, int $pageSize = 15, bool $isSn = false) {
        return self::getClass()->getNps([
            "storeId" => $storeId,
            "orderIds" => $orderIds,
            "staffId" => $staffId,
            "job" => $job,
            "score" => $score,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "page" => $page,
            "pageSize" => $pageSize,
            "isSn" => $isSn,
        ]);
    }

    /**
     * 修改nps
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $nps_all 总评分 [ require true ]
     * @param  int $nps_receptionist 门市客服评分 [ require true ]
     * @param  int $nps_cameraman 摄影师平分 [ require true ]
     * @param  int $nps_dresser 化妆师评分 [ require true ]
     * @param  int $nps_retoucher 看片师评分 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editNps (int $orderId, int $nps_all = 0, int $nps_receptionist = 0, int $nps_cameraman = 0, int $nps_dresser = 0, int $nps_retoucher = 0) {
        return self::getClass()->editNps([
            "orderId" => $orderId,
            "nps_all" => $nps_all,
            "nps_receptionist" => $nps_receptionist,
            "nps_cameraman" => $nps_cameraman,
            "nps_dresser" => $nps_dresser,
            "nps_retoucher" => $nps_retoucher,
        ]);
    }

    /**
     * 获取SN问卷
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSnQuestion () {
        return self::getClass()->getSnQuestion();
    }

    /**
     * 提交SN问卷
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $storeId 门店ID [ require true ]
     * @param  string $userName 用户名 [ require true ]
     * @param  string $userTel 用户手机号 [ require true ]
     * @param  array $answers 答案组 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitSnAnswer (int $orderId, string $storeId, string $userName, string $userTel, array $answers, string $note = '') {
        return self::getClass()->submitSnAnswer([
            "orderId" => $orderId,
            "storeId" => $storeId,
            "userName" => $userName,
            "userTel" => $userTel,
            "answers" => $answers,
            "note" => $note,
        ]);
    }

    /**
     * TODO 逻辑可能不正确
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeOrderPerformance (int $storeId, string $startTime, string $endTime) {
        return self::getClass()->storeOrderPerformance([
            "storeId" => $storeId,
            "startTime" => $startTime,
            "endTime" => $endTime,
        ]);
    }

    /**
     * 获取订单杂选项
     *
     * @param  string $category 类别 [ require true ]
     * @param  int $parent 父级ID, 0: 一级 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderOption (string $category = '', int $parent = 0) {
        return self::getClass()->getOrderOption([
            "category" => $category,
            "parent" => $parent,
        ]);
    }

    /**
     * 创建订单日志
     *
     * @support  int $originalId 源id [ require true ]
     * @support  int $targetId 目标id 
     * @support  string $event 事件 [ require true ]
     * @support  array $payload 载荷 
     * @throws  \Exception
     * @return  int
     */
    public static function createNewOrderLog () {
        return self::getClass()->createNewOrderLog();
    }

    /**
     * 查询日志
     *
     * @param  int $logId 日志id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderLog (int $logId) {
        return self::getClass()->getOrderLog([
            "logId" => $logId,
        ]);
    }

    /**
     * 多条件查询订单日志
     *
     * @param  int $originalId 源id [ require true ]
     * @param  int $targetId 目标id [ require true ]
     * @param  string $event 事件 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryOrderLog (int $originalId = 0, int $targetId = 0, string $event = '') {
        return self::getClass()->queryOrderLog([
            "originalId" => $originalId,
            "targetId" => $targetId,
            "event" => $event,
        ]);
    }

    /**
     * 删除日志
     *
     * @param  int $logId 日志id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delOrderLog (int $logId) {
        return self::getClass()->delOrderLog([
            "logId" => $logId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Tools');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Tools');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}