<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryDsListWithStoreByParams(array $params)
 * @method getOrderStatusByParams(array $params)
 * @method queryOrderUseEsByParams(array $params)
 * @method queryOrderUseDbByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method getSaleDetailByParams(array $params)
 * @method getSalesUseOrderIdByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method createDsByParams(array $params)
 * @method queryDsTotalByParams(array $params)
 * @method editDsByParams(array $params)
 * @method removeDsByParams(array $params)
 * @method changeOrderStoreByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method untieOrderByParams(array $params)
 * @method transformOrderByParams(array $params)
 * @method changeOrderDataByParams(array $params)
 * @method getUserFirstOrderTimeByParams(array $params)
 * @method getOrderSaleByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeOrderPayTypeByParams(array $params)
 * @method financeChangeOrderByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method getOrderOperateLogByParams(array $params)
 * @method changeOrderExtendByParams(array $params)
 * @method onlineMakeupArtistListByParams(array $params)
 * @method getOrderLogDataByParams(array $params)
 * @method recordOrderStatusTimeByParams(array $params)
 * @method pushQueuesByParams(array $params)
 * @method getQueueDataByParams(array $params)
 * @method searchQueueCountByParams(array $params)
 * @method getAllSortsOfCurrentOrderByParams(array $params)
 * @method OrderPushOnlineHandleByParams(array $params)
 * @method pushMessageIntoTheQueueByParams(array $params)
 * @method modifyTheOrderStatusRecordTimeByParams(array $params)
 * @method shutOrderByParams(array $params)
 * @method onTimeCloseOrderByParams(array $params)
 * @method finishOrderByParams(array $params)
 * @method finishMantuOrderByParams(array $params)
 * @method recoverOrderByParams(array $params)
 * @method changeOrderProductByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method exchangeOrderIdByParams(array $params)
 * @method cronChangeToWaitMakeUpByParams(array $params)
 * @method leaveToPayByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据门店查询二销
     *
     * @support  int $dsModel 查询类型 1：共享 2：主推 
     * @support  int $staffId 伙伴id [ require true ]
     * @support  int $storeId 门店id 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function queryDsListWithStore () {
        return self::getClass()->queryDsListWithStore();
    }

    /**
     * 获取门店下订单不同状态数量
     *
     * @param  int $storeId 门店iD [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  bool $needToday 是否仅需要当天数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderStatus (int $storeId, string $module, bool $needToday = false) {
        return self::getClass()->getOrderStatus([
            "storeId" => $storeId,
            "module" => $module,
            "needToday" => $needToday,
        ]);
    }

    /**
     * 订单查询( es版 )
     *
     * @param  array $order_nums 订单编号s [ require true ]
     * @param  array $store_ids 门店ids [ require true ]
     * @param  string $reserve_time_start 预约开始时间 [ require true ]
     * @param  string $reserve_time_end 预约结束时间 [ require true ]
     * @param  string $create_time_start 查询开始时间 [ require true ]
     * @param  string $create_time_end 查询结束时间 [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  array $product_ids 产品ids [ require true ]
     * @param  array $bind_user_ids 绑定用户uids [ require true ]
     * @param  array $order_user_ids 下单用户uids [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @param  string $user_name 下单用户 [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  array $phones 手机号s [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @param  string $origin 订单来源 [ require true ]
     * @param  string $sort_field 排序字段 [ require true ]
     * @param  bool $sort_desc 是否倒序 [ require true ]
     * @param  bool $with_del 是否需要删除数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryOrderUseEs (array $order_nums = [], array $store_ids = [], array $product_ids = [], string $reserve_time_start = '', string $reserve_time_end = '', string $create_time_start = '', string $create_time_end = '', array $bind_user_ids = [], array $order_user_ids = [], array $status = [], array $phones = [], string $user_name = '', string $module = '', string $pay_type = '', string $origin = '', int $page = 1, int $page_size = 15, string $sort_field = '', bool $sort_desc = true, bool $with_del = false) {
        return self::getClass()->queryOrderUseEs([
            "order_nums" => $order_nums,
            "store_ids" => $store_ids,
            "product_ids" => $product_ids,
            "reserve_time_start" => $reserve_time_start,
            "reserve_time_end" => $reserve_time_end,
            "create_time_start" => $create_time_start,
            "create_time_end" => $create_time_end,
            "bind_user_ids" => $bind_user_ids,
            "order_user_ids" => $order_user_ids,
            "status" => $status,
            "phones" => $phones,
            "user_name" => $user_name,
            "module" => $module,
            "pay_type" => $pay_type,
            "origin" => $origin,
            "page" => $page,
            "page_size" => $page_size,
            "sort_field" => $sort_field,
            "sort_desc" => $sort_desc,
            "with_del" => $with_del,
        ]);
    }

    /**
     * 查询订单数据 Mysql
     *
     * @param  array $order_ids 订单编号s [ require true ]
     * @param  array $order_nums 订单ids [ require true ]
     * @param  array $store_ids 门店ids [ require true ]
     * @param  string $reserve_time_start 预约开始时间 [ require true ]
     * @param  string $reserve_time_end 预约结束时间 [ require true ]
     * @param  string $create_time_start 查询开始时间 [ require true ]
     * @param  string $create_time_end 查询结束时间 [ require true ]
     * @param  array $product_ids 产品ids [ require true ]
     * @param  array $bind_user_ids 绑定用户uids [ require true ]
     * @param  array $order_user_ids 下单用户uids [ require true ]
     * @param  array $status 订单状态s [ require true ]
     * @param  string $user_name 下单用户 [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  array $phones 手机号s [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @param  string $sort_field 排序字段 [ require true ]
     * @param  bool $sort_desc 是否倒序 [ require true ]
     * @param  bool $with_del 是否需要删除数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryOrderUseDb (array $order_ids = [], array $order_nums = [], array $store_ids = [], array $product_ids = [], string $reserve_time_start = '', string $reserve_time_end = '', string $create_time_start = '', string $create_time_end = '', array $bind_user_ids = [], array $order_user_ids = [], array $status = [], array $phones = [], string $user_name = '', string $module = '', int $page = 1, int $page_size = 15, string $sort_field = '', bool $sort_desc = true, bool $with_del = false) {
        return self::getClass()->queryOrderUseDb([
            "order_ids" => $order_ids,
            "order_nums" => $order_nums,
            "store_ids" => $store_ids,
            "product_ids" => $product_ids,
            "reserve_time_start" => $reserve_time_start,
            "reserve_time_end" => $reserve_time_end,
            "create_time_start" => $create_time_start,
            "create_time_end" => $create_time_end,
            "bind_user_ids" => $bind_user_ids,
            "order_user_ids" => $order_user_ids,
            "status" => $status,
            "phones" => $phones,
            "user_name" => $user_name,
            "module" => $module,
            "page" => $page,
            "page_size" => $page_size,
            "sort_field" => $sort_field,
            "sort_desc" => $sort_desc,
            "with_del" => $with_del,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $order_num 订单编号 [ require true ]
     * @param  bool $with_del 是否需要删除数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDetail (int $order_id = 0, string $order_num = '', bool $with_del = false) {
        return self::getClass()->getOrderDetail([
            "order_id" => $order_id,
            "order_num" => $order_num,
            "with_del" => $with_del,
        ]);
    }

    /**
     * 获取Sale详情
     *
     * @param  int $saleId saleId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSaleDetail (int $saleId) {
        return self::getClass()->getSaleDetail([
            "saleId" => $saleId,
        ]);
    }

    /**
     * 根据订单id获取订单sales信息
     *
     * @param  int $orderId 订单Id [ require true ]
     * @param  bool $withDel 是否需要删除数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSalesUseOrderId (int $orderId, bool $withDel = false) {
        return self::getClass()->getSalesUseOrderId([
            "orderId" => $orderId,
            "withDel" => $withDel,
        ]);
    }

    /**
     * 创建订单
     *
     * @support  int $reserve_index 预约时间站点 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  float $real_pay_amount 实际支付价格 [Original type double] 
     * @support  float $original_pay_amount 产品价格 [Original type double] [ require true ]
     * @support  string $user_name 下单人名称 [ require true ]
     * @support  int $order_user_id 用户uid [ require true ]
     * @support  string $sex 性别 [ require true ]
     * @support  int $invoice_id 发票id 
     * @support  int $bind_user_id 下单id 
     * @support  int $store_id 店铺id [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $module 订单模块 [ require true ]
     * @support  string $pay_mode 支付模式 [兼容缦图订单] 
     * @support  string $pay_type 支付方式 
     * @support  string $email 用户邮箱 
     * @support  string $birthday 用户生日 
     * @support  string $pay_time 支付时间 
     * @support  array $product_group 产品列表 [ require true ]
     * @support  array $discount_list 折扣列表 
     * @support  string $order_type 订单类型 
     * @support  string $discount_note 优惠备注(缦图) 
     * @support  string $from 订单来源 
     * @support  string $location 用户坐标 
     * @support  string $note 备注 
     * @support  int $kuid 口碑id 
     * @support  int $transfer_store 转门店门店id 
     * @support  int $transfer_order 转门店订单id 
     * @support  int $staff_id 伙伴ID 
     * @support  int $channel 渠道id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 新增二销
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $ds_type ds类型 [ require true ]
     * @support  int $staff_id 员工id [ require true ]
     * @support  array $product_group 产品组 [ require true ]
     * @support  int $old_pid 老产品id 
     * @support  int $people_num 拍摄人数 
     * @support  int $buy_num 二销数量 
     * @support  int $operateId 操作人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDs () {
        return self::getClass()->createDs();
    }

    /**
     * 查询二销统计
     *
     * @param  string $startTime 开始时间 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  string $origin 订单来源 [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryDsTotal (int $storeId, string $startTime, string $endTime, string $payType = '', string $origin = '') {
        return self::getClass()->queryDsTotal([
            "storeId" => $storeId,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "payType" => $payType,
            "origin" => $origin,
        ]);
    }

    /**
     * 修改ds(支付状态)
     *
     * @param  int $sale_id sale id [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editDs (int $sale_id, string $pay_type, int $operateId = 0) {
        return self::getClass()->editDs([
            "sale_id" => $sale_id,
            "pay_type" => $pay_type,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 删除二销
     *
     * @param  int $sale_id sale id [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeDs (int $sale_id, int $operateId = 0) {
        return self::getClass()->removeDs([
            "sale_id" => $sale_id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 订单转门店
     *
     * @param  int $old_order_id 原订单ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @param  int $index 占位值 [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @param  string $note 转门店备注 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderStore (int $old_order_id, int $store_id, string $reserve_time, string $note, int $operateId = 0, int $index = 0) {
        return self::getClass()->changeOrderStore([
            "old_order_id" => $old_order_id,
            "store_id" => $store_id,
            "reserve_time" => $reserve_time,
            "note" => $note,
            "operateId" => $operateId,
            "index" => $index,
        ]);
    }

    /**
     * 绑定订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $uid 用户uid [ require true ]
     * @param  bool $isBind 是否属于绑定 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $order_id, int $uid, bool $isBind = true, int $operateId = 0) {
        return self::getClass()->bindOrder([
            "order_id" => $order_id,
            "uid" => $uid,
            "isBind" => $isBind,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 解绑订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function untieOrder (int $order_id, int $operateId = 0) {
        return self::getClass()->untieOrder([
            "order_id" => $order_id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 订单号转换成订单id ----- 订单id转换成订单号
     * @deprecated
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function transformOrder (string $order_num) {
        return self::getClass()->transformOrder([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 更改当前订单的信息
     *
     * @support  int $id 订单id 
     * @support  string $status 订单状态 
     * @support  int $store_id 门店id 
     * @support  string $birthday 生日 
     * @support  string $sex 性别 
     * @support  string $email 邮箱 
     * @support  string $user_name 用户姓名 
     * @support  string $invoice_id 发票id 
     * @support  string $order_type 订单类型 
     * @support  int $operateId 操作人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderData () {
        return self::getClass()->changeOrderData();
    }

    /**
     * 查询用户的首次下单时间
     *
     * @param  array $user_ids 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserFirstOrderTime (array $user_ids) {
        return self::getClass()->getUserFirstOrderTime([
            "user_ids" => $user_ids,
        ]);
    }

    /**
     * 获取当前门店下指定产品销售量
     *
     * @param  int $store_id 店铺id [ require true ]
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderSale (int $store_id, int $product_id) {
        return self::getClass()->getOrderSale([
            "store_id" => $store_id,
            "product_id" => $product_id,
        ]);
    }

    /**
     * 修改订单预约时间
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime (int $order_id, string $reserve_time, int $operateId = 0) {
        return self::getClass()->changeReserveTime([
            "order_id" => $order_id,
            "reserve_time" => $reserve_time,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改订单支付方式
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @param  string $paymentId 支付id [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderPayType (int $orderId, string $payType, string $paymentId = '', int $operateId = 0) {
        return self::getClass()->changeOrderPayType([
            "orderId" => $orderId,
            "payType" => $payType,
            "paymentId" => $paymentId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 财务修改订单流水(包含DS与订单支付方式,无任何限制)
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $dsId 订单二销ID [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @param  int $type 修改类型 1-订单支付方式,2-DS支付方式,3-删除DS [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function financeChangeOrder (int $type, int $orderId = 0, string $payType = '', int $dsId = 0, int $operateId = 0) {
        return self::getClass()->financeChangeOrder([
            "type" => $type,
            "orderId" => $orderId,
            "payType" => $payType,
            "dsId" => $dsId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量更新一批订单的发票id
     *
     * @param  array $orderNums 订单号s [ require true ]
     * @param  int $invoiceId 发票ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (array $orderNums, int $invoiceId) {
        return self::getClass()->batchUpdateInvoiceId([
            "orderNums" => $orderNums,
            "invoiceId" => $invoiceId,
        ]);
    }

    /**
     * 查看订单操作日志
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOperateLog (int $orderId) {
        return self::getClass()->getOrderOperateLog([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修改订单扩展信息
     *
     * @support  int $id 订单号 
     * @support  int $kuid 口碑id 
     * @support  string $note 备注 
     * @support  string $location 用户位置 
     * @support  string $start_time 流程开始时间 
     * @support  int $modify_count 修改次数 [Original type uint] 
     * @support  int $transfer_order 转门店订单id 
     * @support  int $transfer_store 转门店 
     * @support  string $close_note 关闭原因 
     * @support  int $operateId 操作人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderExtend () {
        return self::getClass()->changeOrderExtend();
    }

    /**
     * 查询当前订单接单化妆师
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onlineMakeupArtistList (int $order_id) {
        return self::getClass()->onlineMakeupArtistList([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 查询订单日志相关信息
     *
     * @param  int $original_id 来源id [ require true ]
     * @param  int $target_id 目标id [ require true ]
     * @param  string $event 事件 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderLogData (int $original_id = 0, int $target_id = 0, string $event = '') {
        return self::getClass()->getOrderLogData([
            "original_id" => $original_id,
            "target_id" => $target_id,
            "event" => $event,
        ]);
    }

    /**
     * [无纸化] 修改订单当前当前的状态
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $status 当前修改的状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recordOrderStatusTime (int $order_id, string $status) {
        return self::getClass()->recordOrderStatusTime([
            "order_id" => $order_id,
            "status" => $status,
        ]);
    }

    /**
     * [无纸化]  推数据到队列当中
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  array $payload 载荷 [ require true ]
     * @param  int $order_id 订单id [ require true ]
     * @param  int $sort 优先级序号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushQueues (int $store_id, int $staff_id, string $type, array $payload, int $order_id, int $sort = 0) {
        return self::getClass()->pushQueues([
            "store_id" => $store_id,
            "staff_id" => $staff_id,
            "type" => $type,
            "payload" => $payload,
            "order_id" => $order_id,
            "sort" => $sort,
        ]);
    }

    /**
     * [无纸化]  接单数据
     *
     * @param  string $type 类型 [ require true ]
     * @param  int $store 门店id [ require true ]
     * @param  bool $staffId 是否有员工id [ require true ]
     * @param  bool $onlyMe 只显示自己的 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueData (string $type, int $store, bool $staffId, bool $onlyMe) {
        return self::getClass()->getQueueData([
            "type" => $type,
            "store" => $store,
            "staffId" => $staffId,
            "onlyMe" => $onlyMe,
        ]);
    }

    /**
     * [无纸化]  获取当前可接订单数
     *
     * @param  string $job 岗位名称 [ require true ]
     * @param  int $store 门店id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function searchQueueCount (string $job, int $store) {
        return self::getClass()->searchQueueCount([
            "job" => $job,
            "store" => $store,
        ]);
    }

    /**
     * [无纸化]  获得所有队列中可接的单子
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSortsOfCurrentOrder () {
        return self::getClass()->getAllSortsOfCurrentOrder();
    }

    /**
     * [无纸化]  增加一条接单数据
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  int $divider_id 分配者 [ require true ]
     * @param  int $record_id 对应状态id [ require true ]
     * @param  int $is_master 是否为主接单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function OrderPushOnlineHandle (int $order_id = 0, int $divider_id = 0, int $staff_id = 0, int $record_id = 0, int $is_master = 1) {
        return self::getClass()->OrderPushOnlineHandle([
            "order_id" => $order_id,
            "divider_id" => $divider_id,
            "staff_id" => $staff_id,
            "record_id" => $record_id,
            "is_master" => $is_master,
        ]);
    }

    /**
     * [无纸化]  推送消息到队列当中
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $status 当前修改的状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushMessageIntoTheQueue (int $order_id, string $status) {
        return self::getClass()->pushMessageIntoTheQueue([
            "order_id" => $order_id,
            "status" => $status,
        ]);
    }

    /**
     * 修改状态并记录时间
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $next_status 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyTheOrderStatusRecordTime (int $order_id, string $next_status) {
        return self::getClass()->modifyTheOrderStatusRecordTime([
            "order_id" => $order_id,
            "next_status" => $next_status,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  string $type 关单类型(no_pay,transfer,refund,console) [ require true ]
     * @param  int $order_id 订单id [ require true ]
     * @param  string $reason 原因 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shutOrder (int $order_id, string $type, string $reason = '', int $operateId = 0) {
        return self::getClass()->shutOrder([
            "order_id" => $order_id,
            "type" => $type,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 自动关闭一个小时之外的订单(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function onTimeCloseOrder () {
        return self::getClass()->onTimeCloseOrder();
    }

    /**
     * 完成订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  array $workLoad 工作量数组 [ require true ]
     * @param  int $operateId 录单人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishOrder (int $orderId, array $workLoad, int $operateId = 0) {
        return self::getClass()->finishOrder([
            "orderId" => $orderId,
            "workLoad" => $workLoad,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 完成缦图订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $operateId 录单人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishMantuOrder (int $orderId, int $operateId) {
        return self::getClass()->finishMantuOrder([
            "orderId" => $orderId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 恢复订单-仅限海马体
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverOrder (int $orderId, int $operateId = 0) {
        return self::getClass()->recoverOrder([
            "orderId" => $orderId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 更换产品
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $old_pid 老产品id [ require true ]
     * @param  int $new_pid 新产品id [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderProduct (int $order_id, int $old_pid, int $new_pid, int $operateId = 0) {
        return self::getClass()->changeOrderProduct([
            "order_id" => $order_id,
            "old_pid" => $old_pid,
            "new_pid" => $new_pid,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder (int $order_id, int $operateId = 0) {
        return self::getClass()->deleteOrder([
            "order_id" => $order_id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 交换订单id
     *
     * @param  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeOrderId (string $order_num) {
        return self::getClass()->exchangeOrderId([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 签到排队状态距预约时间5分钟时自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronChangeToWaitMakeUp () {
        return self::getClass()->cronChangeToWaitMakeUp();
    }

    /**
     * 尾款录入
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @param  float $payMoney 金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function leaveToPay (int $orderId, string $payType, float $payMoney) {
        return self::getClass()->leaveToPay([
            "orderId" => $orderId,
            "payType" => $payType,
            "payMoney" => $payMoney,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}