<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRefundChangeByParams(array $params)
 * @method queryRefundChangeByParams(array $params)
 * @method handleRefundChangeByParams(array $params)
 */
class RefundChange {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 申请转退
     *
     * @support  int $refundId 退款id [ require true ]
     * @support  int $staffId 操作人id [ require true ]
     * @support  string $refundUsername 退款人用户 [ require true ]
     * @support  string $refundAccount 退款账户 [ require true ]
     * @support  string $refundNote 退款备注 [ require true ]
     * @support  int $isStaff 伙伴是否垫付 1是 0 否 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRefundChange () {
        return self::getClass()->createRefundChange();
    }

    /**
     * 查询转退列表
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $refundStatus 退款状态 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryRefundChange (int $orderId = 0, string $refundStatus = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->queryRefundChange([
            "orderId" => $orderId,
            "refundStatus" => $refundStatus,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 处理转退款申请
     *
     * @param  int $changeId 转退id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleRefundChange (int $changeId) {
        return self::getClass()->handleRefundChange([
            "changeId" => $changeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'RefundChange');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'RefundChange');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}