<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryBusinessOrderByParams(array $params)
 * @method createBusinessOrderByParams(array $params)
 * @method changeBusinessOrderByParams(array $params)
 * @method deleteBusinessOrderByParams(array $params)
 * @method bindHimoOrderByParams(array $params)
 * @method generateOrderNumByParams(array $params)
 */
class BusinessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询企业版订单
     *
     * @param  array $ids 企业版订单id [ require true ]
     * @param  array $serialNumber 企业版订单号 [ require true ]
     * @param  array $orderType 订单类型 [ require true ]
     * @param  array $customerId 用户UID [ require true ]
     * @param  array $creatorId 创建人UID [ require true ]
     * @param  array $invoiceStatus 开票状态 [ require true ]
     * @param  array $reviewStatus 订单审核状态 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryBusinessOrder (array $ids = [], array $serialNumber = [], array $orderType = [], array $customerId = [], array $creatorId = [], array $invoiceStatus = [], array $reviewStatus = [], string $startTime = '', string $endTime = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->queryBusinessOrder([
            "ids" => $ids,
            "serialNumber" => $serialNumber,
            "orderType" => $orderType,
            "customerId" => $customerId,
            "creatorId" => $creatorId,
            "invoiceStatus" => $invoiceStatus,
            "reviewStatus" => $reviewStatus,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 增加企业版订单
     *
     * @support  string $orderType 企业版订单类型 
     * @support  float $payAmount 支付金额 [Original type double] 
     * @support  int $customerId 用户id 
     * @support  int $creatorId 创建者id 
     * @support  string $reviewStatus 订单审核状态 
     * @support  string $invoiceStatus 开票状态 
     * @support  string $invoiceId 发票id 
     * @support  string $contractId 合同id 
     * @support  int $storeId 门店id 
     * @support  int $productId 产品id 
     * @support  string $reserveTime 预约时间 
     * @support  string $orderPattern 下单模式 
     * @support  int $productNum 产品数量 
     * @support  float $productAmount 产品金额 [Original type double] 
     * @support  float $serviceAmount 服务金额 [Original type double] 
     * @support  string $shootingStatus 拍摄状态 
     * @support  string $cardType 卡类型 
     * @support  int $coverId 礼品卡卡面id 
     * @support  float $cardMoney 卡面值 [Original type double] 
     * @support  string $codeListId 存储券码列表_id 
     * @support  string $expressState 快递状态 
     * @support  int $cardNum 卡数量 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createBusinessOrder () {
        return self::getClass()->createBusinessOrder();
    }

    /**
     * 修改企业版订单
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  string $orderType 企业版订单类型 
     * @support  float $payAmount 支付金额 [Original type double] 
     * @support  int $customerId 用户id 
     * @support  int $creatorId 创建者id 
     * @support  string $invoiceStatus 开票状态 
     * @support  string $reviewStatus 订单审核状态 
     * @support  string $invoiceId 发票id 
     * @support  string $contractId 合同id 
     * @support  int $storeId 门店id 
     * @support  int $productId 产品id 
     * @support  string $reserveTime 预约时间 
     * @support  string $orderPattern 下单模式 
     * @support  int $productNum 产品数量 
     * @support  float $productAmount 产品金额 [Original type double] 
     * @support  float $serviceAmount 服务金额 [Original type double] 
     * @support  string $shootingStatus 拍摄状态 
     * @support  string $cardType 卡类型 
     * @support  int $coverId 礼品卡卡面id 
     * @support  float $cardMoney 卡面值 [Original type double] 
     * @support  string $codeListId 存储券码列表_id 
     * @support  string $expressState 快递状态 
     * @support  int $cardNum 卡数量 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeBusinessOrder () {
        return self::getClass()->changeBusinessOrder();
    }

    /**
     * 删除企业版订单
     *
     * @param  array $ids 订单id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteBusinessOrder (array $ids) {
        return self::getClass()->deleteBusinessOrder([
            "ids" => $ids,
        ]);
    }

    /**
     * 绑定海马体订单
     *
     * @support  int $businessId 企业版订单id [ require true ]
     * @support  array $orderNumArray 海马体订单号数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindHimoOrder () {
        return self::getClass()->bindHimoOrder();
    }

    /**
     * 生成订单号
     *
     * @throws  \Exception
     * @return  string
     */
    public static function generateOrderNum () {
        return self::getClass()->generateOrderNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'BusinessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'BusinessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}