<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addOrderDataByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method getUserOrderDataByParams(array $params)
 * @method queryOrderDataByParams(array $params)
 * @method enterTheSecondSalesByParams(array $params)
 * @method getOrderDataByConditionByParams(array $params)
 * @method batchGetOrderDataByParams(array $params)
 * @method delDiscountByParams(array $params)
 * @method addDiscountByParams(array $params)
 * @method createPaymentDataByParams(array $params)
 * @method getUserNeedPayMoneyByParams(array $params)
 * @method getOrderAllPriceByParams(array $params)
 * @method getOrderOriginPriceByParams(array $params)
 * @method changeOrderReserveByParams(array $params)
 * @method startShootingByParams(array $params)
 * @method matchGetOrderIdByParams(array $params)
 * @method deleteDsInfoByParams(array $params)
 * @method queryDsByStoreByParams(array $params)
 * @method getBatchOrderByParams(array $params)
 */
class MicroOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增一条订单
     *
     * @support  int $user_id 用户id 
     * @support  int $store_id 门店id 
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  string $origin 订单来源(pc或者mobile) 
     * @support  string $location 用户定位 
     * @support  int $purchase_id 下单id 
     * @support  float $price 订单金额 [Original type double] [ require true ]
     * @support  string $note 备注信息 
     * @support  int $invoice_id 发票id 
     * @support  int $lock_staff_id 录单人员 
     * @support  string $user_name 用户名称 
     * @support  string $module 订单属于哪个模块 [ require true ]
     * @support  string $birthday 生日 
     * @support  array $product 购买的产品 
     * @support  string $email 邮箱 
     * @support  string $sex 性别 
     * @support  int $preferential_id 优惠券id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOrderData () {
        return self::getClass()->addOrderData();
    }

    /**
     * 获取订单详细信息
     *
     * @param  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDetail (int $orderId) {
        return self::getClass()->getOrderDetail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据用户id获取当前的订单
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $module 所属模块 [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @param  int $page 页数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserOrderData (int $user_id, string $module, array $status = [], int $page = 1) {
        return self::getClass()->getUserOrderData([
            "user_id" => $user_id,
            "module" => $module,
            "status" => $status,
            "page" => $page,
        ]);
    }

    /**
     * 搜索订单数据
     *
     * @param  array $user_id 用户id [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @param  string $state 订单状态 [ require true ]
     * @param  array $order_num_array 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryOrderData (array $user_id = [], string $order_num = '', string $module = 'himo', int $page = 1, int $page_size = 10, string $state = '', array $order_num_array = []) {
        return self::getClass()->queryOrderData([
            "user_id" => $user_id,
            "order_num" => $order_num,
            "module" => $module,
            "page" => $page,
            "page_size" => $page_size,
            "state" => $state,
            "order_num_array" => $order_num_array,
        ]);
    }

    /**
     * 增加ds产品和流水
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $product_id 产品 [ require true ]
     * @param  string $type 二销类型 [ require true ]
     * @param  float $price 二销价格 [Original type double] [ require true ]
     * @param  int $pay_id 员工 [Original type uint] [ require true ]
     * @param  string $pay_type 支付状态 [ require true ]
     * @param  int $buy_num 购买数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enterTheSecondSales (int $order_id, int $product_id, string $type, float $price, int $pay_id, string $pay_type, int $buy_num) {
        return self::getClass()->enterTheSecondSales([
            "order_id" => $order_id,
            "product_id" => $product_id,
            "type" => $type,
            "price" => $price,
            "pay_id" => $pay_id,
            "pay_type" => $pay_type,
            "buy_num" => $buy_num,
        ]);
    }

    /**
     * 根据条件过滤订单信息
     *
     * @param  string $module 查找模块 [ require true ]
     * @param  array $user_id 用户id [ require true ]
     * @param  array $pay_mode 支付模式 [ require true ]
     * @param  array $state 订单状态 [ require true ]
     * @param  array $order_id 订单id [ require true ]
     * @param  string $user_name 订单人姓名 [ require true ]
     * @param  int $page 页数 [ require true ]
     * @param  int $count 一页数量 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDataByCondition (string $module, array $user_id = [], array $pay_mode = [], array $state = [], array $order_id = [], string $user_name = '', int $page = 1, int $count = 10, int $store_id = 0) {
        return self::getClass()->getOrderDataByCondition([
            "module" => $module,
            "user_id" => $user_id,
            "pay_mode" => $pay_mode,
            "state" => $state,
            "order_id" => $order_id,
            "user_name" => $user_name,
            "page" => $page,
            "count" => $count,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 根据订单id获取订单基础信息
     *
     * @param  array $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetOrderData (array $order_id) {
        return self::getClass()->batchGetOrderData([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 删除优惠折扣
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $turnover_id 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delDiscount () {
        return self::getClass()->delDiscount();
    }

    /**
     * 新增优惠折扣
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  array $discount 优惠折扣 [ require true ]
     * @support  int $pay_id 网关，无就写0 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addDiscount () {
        return self::getClass()->addDiscount();
    }

    /**
     * 生成用户支付信息
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  float $pay_money 支付金额 [Original type double] 
     * @support  string $pay_type 支付方式 
     * @support  array $discount 优惠折扣 
     * @support  int $pay_id 网关，无就写0 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPaymentData () {
        return self::getClass()->createPaymentData();
    }

    /**
     * 获取用户还需要支付的金额
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserNeedPayMoney (int $order_id) {
        return self::getClass()->getUserNeedPayMoney([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取订单所有价格
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderAllPrice (int $order_id) {
        return self::getClass()->getOrderAllPrice([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取产品原价格，用户支付，优惠金额
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOriginPrice (int $order_id) {
        return self::getClass()->getOrderOriginPrice([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 修改预约时间点
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderReserve (int $order_id, string $reserve_time) {
        return self::getClass()->changeOrderReserve([
            "order_id" => $order_id,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 开始拍摄，修改订单状态
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startShooting (int $order_id) {
        return self::getClass()->startShooting([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 模糊查询获取订单id
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function matchGetOrderId (string $order_num) {
        return self::getClass()->matchGetOrderId([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 删除二销
     *
     * @param  int $sale_id 二销id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDsInfo (int $sale_id) {
        return self::getClass()->deleteDsInfo([
            "sale_id" => $sale_id,
        ]);
    }

    /**
     * 根据门店查询ds数据
     *
     * @param  int $ds_model 查询ds类型 1:共享 2主推 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  string $start_time 查询开始时间 [ require true ]
     * @param  string $end_time 查询结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryDsByStore (int $ds_model, int $store_id, int $staff_id, string $start_time, string $end_time, int $page = 1, int $page_size = 15) {
        return self::getClass()->queryDsByStore([
            "ds_model" => $ds_model,
            "store_id" => $store_id,
            "staff_id" => $staff_id,
            "start_time" => $start_time,
            "end_time" => $end_time,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 批量获取订单 (缦图)
     *
     * @param  string $order_num 订单单号 [ require true ]
     * @param  string $module 订单模块名称 [ require true ]
     * @param  array $userIds 用户IDs [ require true ]
     * @param  string $userName 用户名字 [ require true ]
     * @param  int $page 分页 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBatchOrder (string $module, string $order_num = '', array $userIds = [], string $userName = '', int $page = 1) {
        return self::getClass()->getBatchOrder([
            "module" => $module,
            "order_num" => $order_num,
            "userIds" => $userIds,
            "userName" => $userName,
            "page" => $page,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'MicroOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'MicroOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}