<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updatePendingStatusByParams(array $params)
 * @method getOrderSpecialInformationByParams(array $params)
 * @method getOrderStatesWithCountByParams(array $params)
 * @method getQueueDataByParams(array $params)
 * @method getOneQueueByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 * @method getQueueCountByParams(array $params)
 * @method addOrderOnlineDataByParams(array $params)
 * @method searchStaffWorkingOrderByParams(array $params)
 * @method modifyOrderOnlineStateByParams(array $params)
 * @method modifyOrderOnlineDividerByParams(array $params)
 * @method returnSupportOrderByParams(array $params)
 * @method deleteQueueDataByParams(array $params)
 * @method searchQueueCountByParams(array $params)
 * @method searchQueueDataByParams(array $params)
 * @method getOrderOnlineInfoByParams(array $params)
 * @method getOrderProcessStatusDataByParams(array $params)
 * @method queryOrderProcessTimeByParams(array $params)
 * @method queryOrderArrayProcessTimeByParams(array $params)
 * @method getOrderStateRecordByParams(array $params)
 * @method modifyQueueDataByParams(array $params)
 * @method clearOnlineInfoByParams(array $params)
 * @method getOrderStateRecordByOrderByParams(array $params)
 * @method deleteOnlineOrderDataByParams(array $params)
 * @method getOnlineOrdersByParams(array $params)
 * @method modifyOnlineOrderDataByParams(array $params)
 * @method employeesAreCurrentlyTakingOrdersByParams(array $params)
 * @method storeProcessStatisticsByParams(array $params)
 * @method storeProcessStatisticsForEfficiencyByParams(array $params)
 * @method storeOrderStatusStatisticsByParams(array $params)
 * @method recordStatusByParams(array $params)
 * @method searchSaleInOrderByParams(array $params)
 * @method adjustAbnormalSelectStatusByParams(array $params)
 * @method getUsedProductIdsByParams(array $params)
 * @method getOrderOnlineDataByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method queryStoreProcessStatisticsByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method sendCodeByParams(array $params)
 * @method getOrderDataUsePageV2ByParams(array $params)
 * @method getOrderPendingStatusWithCountV2ByParams(array $params)
 * @method receptionistSignInByParams(array $params)
 * @method adjustOrderStatusByParams(array $params)
 * @method giveOrderToStaffByParams(array $params)
 * @method getTodayShootingOrderIdsByParams(array $params)
 * @method cameramanCompleteOrderByParams(array $params)
 * @method dresserCompleteOrderByParams(array $params)
 * @method returnToMakeUpByParams(array $params)
 * @method finishSelectPhotoByParams(array $params)
 * @method getCurrentWorkingOrdersByParams(array $params)
 * @method giveOrderToStaffByDingDingByParams(array $params)
 * @method clearAllNoPaperInfoByParams(array $params)
 * @method wsTakeOrderByParams(array $params)
 * @method changeToWaitMakeUpByParams(array $params)
 * @method getStaffProcessTimeByOrderIdsByParams(array $params)
 * @method getLastDresserByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新pending状态
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $pendingStatus pending状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePendingStatus (int $orderId, string $pendingStatus) {
        return self::getClass()->updatePendingStatus([
            "orderId" => $orderId,
            "pendingStatus" => $pendingStatus,
        ]);
    }

    /**
     * 获取订单额外信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderSpecialInformation (int $order_id, array $type = []) {
        return self::getClass()->getOrderSpecialInformation([
            "order_id" => $order_id,
            "type" => $type,
        ]);
    }

    /**
     * 获取带数量的订单状态列表
     *
     * @param  int $storeId 门店iD [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStatesWithCount (int $storeId) {
        return self::getClass()->getOrderStatesWithCount([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取队列中数据
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  bool $onlyMe 是否只搜索自己的 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueData (int $staffId, string $type, int $storeId, bool $onlyMe) {
        return self::getClass()->getQueueData([
            "staffId" => $staffId,
            "type" => $type,
            "storeId" => $storeId,
            "onlyMe" => $onlyMe,
        ]);
    }

    /**
     * 获取队列中数据
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  array $type 类型 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  bool $onlyMe 是否只搜索自己的 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOneQueue (int $staffId, array $type, int $storeId, bool $onlyMe) {
        return self::getClass()->getOneQueue([
            "staffId" => $staffId,
            "type" => $type,
            "storeId" => $storeId,
            "onlyMe" => $onlyMe,
        ]);
    }

    /**
     * 得到当前门店在当前等待状态下的优先队列末尾序号
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastQueueSort (int $storeId, string $type) {
        return self::getClass()->getLastQueueSort([
            "storeId" => $storeId,
            "type" => $type,
        ]);
    }

    /**
     * getQueueCount
     *
     * @param  int $storeId 店铺id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getQueueCount (int $storeId, string $type) {
        return self::getClass()->getQueueCount([
            "storeId" => $storeId,
            "type" => $type,
        ]);
    }

    /**
     * addOrderOnlineData
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $dividerId 分配者id [ require true ]
     * @param  int $staffId 工号 [ require true ]
     * @param  int $recordId 状态id [ require true ]
     * @param  bool $isMaster 是否为主接单人 [ require true ]
     * @param  string $source 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOrderOnlineData (int $orderId, string $dividerId = NULL, int $staffId = 0, int $recordId = 0, bool $isMaster = true, string $source = NULL) {
        return self::getClass()->addOrderOnlineData([
            "orderId" => $orderId,
            "dividerId" => $dividerId,
            "staffId" => $staffId,
            "recordId" => $recordId,
            "isMaster" => $isMaster,
            "source" => $source,
        ]);
    }

    /**
     * 查询当前员工接单数据
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $staffType 员工类型 [ require true ]
     * @param  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchStaffWorkingOrder (int $staffId, string $staffType, int $orderId = 0) {
        return self::getClass()->searchStaffWorkingOrder([
            "staffId" => $staffId,
            "staffType" => $staffType,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修改在线订单状态
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @param  string $state 状态 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyOrderOnlineState (int $orderId, int $staffId = 0, string $state = '', string $note = '') {
        return self::getClass()->modifyOrderOnlineState([
            "orderId" => $orderId,
            "staffId" => $staffId,
            "state" => $state,
            "note" => $note,
        ]);
    }

    /**
     * 修改订单分配者
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @param  int $dividerId 分配者 [ require true ]
     * @param  string $source 来源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyOrderOnlineDivider (int $orderId, int $staffId, int $dividerId, string $source = NULL) {
        return self::getClass()->modifyOrderOnlineDivider([
            "orderId" => $orderId,
            "staffId" => $staffId,
            "dividerId" => $dividerId,
            "source" => $source,
        ]);
    }

    /**
     * 退回辅助订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnSupportOrder (int $orderId, int $staffId) {
        return self::getClass()->returnSupportOrder([
            "orderId" => $orderId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 删除队列数据
     *
     * @param  int $id 队列id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteQueueData (int $id) {
        return self::getClass()->deleteQueueData([
            "id" => $id,
        ]);
    }

    /**
     * 搜索队列数量
     *
     * @param  string $type 类型 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function searchQueueCount (string $type, int $storeId) {
        return self::getClass()->searchQueueCount([
            "type" => $type,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 搜索队列中数据
     *
     * @param  int $id 队列id [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @param  array $type 队列类型 [ require true ]
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchQueueData (int $id = 0, int $store_id = 0, int $staff_id = 0, array $type = [], int $order_id = 0) {
        return self::getClass()->searchQueueData([
            "id" => $id,
            "store_id" => $store_id,
            "staff_id" => $staff_id,
            "type" => $type,
            "order_id" => $order_id,
        ]);
    }

    /**
     * 查询在线订单数据
     *
     * @param  int $staff_id 员工id [ require true ]
     * @support  string $job 员工岗位 
     * @param  int $order_id 订单id [ require true ]
     * @param  array $order_ids 订单ids [ require true ]
     * @param  array $is_complete 是否完成 [ require true ]
     * @param  array $is_master 是否为主接单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnlineInfo (int $staff_id = 0, int $order_id = 0, array $is_complete = [], array $is_master = [], array $order_ids = []) {
        return self::getClass()->getOrderOnlineInfo([
            "staff_id" => $staff_id,
            "order_id" => $order_id,
            "is_complete" => $is_complete,
            "is_master" => $is_master,
            "order_ids" => $order_ids,
        ]);
    }

    /**
     * 查询订单流程时间数据
     *
     * @param  array $record_id 状态id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderProcessStatusData (array $record_id = []) {
        return self::getClass()->getOrderProcessStatusData([
            "record_id" => $record_id,
        ]);
    }

    /**
     * 查询订单流程时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryOrderProcessTime (int $orderId) {
        return self::getClass()->queryOrderProcessTime([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 查询多笔订单订单流程时间
     *
     * @param  array $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryOrderArrayProcessTime (array $orderIds) {
        return self::getClass()->queryOrderArrayProcessTime([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取订单状态时间
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderStateRecord (int $recordId) {
        return self::getClass()->getOrderStateRecord([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 修改队列数据
     *
     * @param  int $queueId 队列id [ require true ]
     * @param  string $type 队列类型 [ require true ]
     * @param  int $sort 序号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyQueueData (int $queueId, string $type, int $sort) {
        return self::getClass()->modifyQueueData([
            "queueId" => $queueId,
            "type" => $type,
            "sort" => $sort,
        ]);
    }

    /**
     * 清除残留的在线订单数据
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearOnlineInfo (int $orderId) {
        return self::getClass()->clearOnlineInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 通过订单id查找订单状态记录
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStateRecordByOrder (int $orderId) {
        return self::getClass()->getOrderStateRecordByOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 删除在线订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOnlineOrderData (int $order_id, int $staff_id) {
        return self::getClass()->deleteOnlineOrderData([
            "order_id" => $order_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 获取在线可接订单
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $job 员工岗位 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getOnlineOrders (int $store_id, string $job) {
        return self::getClass()->getOnlineOrders([
            "store_id" => $store_id,
            "job" => $job,
        ]);
    }

    /**
     * 完成订单并加备注
     *
     * @support  int $order_id 订单id 
     * @support  int $staff_id 岗位 
     * @support  string $note 订单备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyOnlineOrderData () {
        return self::getClass()->modifyOnlineOrderData();
    }

    /**
     * 查询员工当前正在接的单
     *
     * @param  int $staff_id 员工id [ require true ]
     * @support  string $job 员工岗位 
     * @param  int $order_id 订单id [ require true ]
     * @param  array $is_complete 是否完成 [ require true ]
     * @param  array $is_master 是否为主接单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function employeesAreCurrentlyTakingOrders (int $staff_id = 0, int $order_id = 0, array $is_complete = [], array $is_master = []) {
        return self::getClass()->employeesAreCurrentlyTakingOrders([
            "staff_id" => $staff_id,
            "order_id" => $order_id,
            "is_complete" => $is_complete,
            "is_master" => $is_master,
        ]);
    }

    /**
     * 指定时间范围内门店各流程状态时间统计
     *
     * @param  array $store_ids 门店组 [ require true ]
     * @param  string $start_date 开始时间 [ require true ]
     * @param  string $end_date 结束时间 [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeProcessStatistics (array $store_ids = [], string $start_date = '', string $end_date = '', array $status = []) {
        return self::getClass()->storeProcessStatistics([
            "store_ids" => $store_ids,
            "start_date" => $start_date,
            "end_date" => $end_date,
            "status" => $status,
        ]);
    }

    /**
     * 门店效率统计：指定时间范围内门店各流程状态时间统计
     *
     * @param  array $store_ids 门店组 [ require true ]
     * @param  string $start_date 开始时间 [ require true ]
     * @param  string $end_date 结束时间 [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @support  int $product_id 产品id 
     * @throws  \Exception
     * @return  array
     */
    public static function storeProcessStatisticsForEfficiency (array $store_ids = [], string $start_date = '', string $end_date = '', array $status = []) {
        return self::getClass()->storeProcessStatisticsForEfficiency([
            "store_ids" => $store_ids,
            "start_date" => $start_date,
            "end_date" => $end_date,
            "status" => $status,
        ]);
    }

    /**
     * 指定时间范围内门店订单状态时间统计
     *
     * @param  array $store_ids 门店组 [ require true ]
     * @param  string $start_date 开始时间 [ require true ]
     * @param  string $end_date 结束时间 [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeOrderStatusStatistics (array $store_ids = [], string $start_date = '', string $end_date = '', array $status = []) {
        return self::getClass()->storeOrderStatusStatistics([
            "store_ids" => $store_ids,
            "start_date" => $start_date,
            "end_date" => $end_date,
            "status" => $status,
        ]);
    }

    /**
     * 结束状态记录时间
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recordStatus (int $order_id) {
        return self::getClass()->recordStatus([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取订单售卖产品
     *
     * @param  array $orderIds 订单ids [ require true ]
     * @param  array $saleType 售卖类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchSaleInOrder (array $orderIds = [], array $saleType = []) {
        return self::getClass()->searchSaleInOrder([
            "orderIds" => $orderIds,
            "saleType" => $saleType,
        ]);
    }

    /**
     * 清理选片状态异常订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustAbnormalSelectStatus () {
        return self::getClass()->adjustAbnormalSelectStatus();
    }

    /**
     * 获取使用的产品列表id
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUsedProductIds () {
        return self::getClass()->getUsedProductIds();
    }

    /**
     * 获取伙伴对应的时长
     *
     * @support  array $staff_ids 伙伴ids [ require true ]
     * @support  string $start_at 开始日期 
     * @support  string $end_at 结束日期 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnlineData () {
        return self::getClass()->getOrderOnlineData();
    }

    /**
     * getOrderInfo
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfo () {
        return self::getClass()->getOrderInfo();
    }

    /**
     * 指定时间范围内各个门店流程状态时间统计
     *
     * @param  array $store_ids 门店组 [ require true ]
     * @param  string $start_date 开始时间 [ require true ]
     * @param  string $end_date 结束时间 [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @support  int $product_id 产品id 
     * @throws  \Exception
     * @return  array
     */
    public static function queryStoreProcessStatistics (array $store_ids = [], string $start_date = '', string $end_date = '', array $status = []) {
        return self::getClass()->queryStoreProcessStatistics([
            "store_ids" => $store_ids,
            "start_date" => $start_date,
            "end_date" => $end_date,
            "status" => $status,
        ]);
    }

    /**
     * [管]绑定订单
     *
     * @param  int $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $code) {
        return self::getClass()->bindOrder([
            "code" => $code,
        ]);
    }

    /**
     * [管]订单绑定发送验证码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCode (string $phone, string $order_num) {
        return self::getClass()->sendCode([
            "phone" => $phone,
            "order_num" => $order_num,
        ]);
    }

    /**
     * 获取订单列表
     *
     * @param  array $store_id 门店id [ require true ]
     * @param  array $user_id 用户id [ require true ]
     * @param  array $product_id 产品id [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @param  array $pending_status 无纸化状态 [ require true ]
     * @param  string $start_time 开始时间 [ require true ]
     * @param  string $end_time 结束时间 (搜索订单创建时间) [ require true ]
     * @param  string $reserve_start_at 预约开始时间 [ require true ]
     * @param  string $reserve_end_at 预约结束时间 [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @param  int $page 当前的页数 [Original type uint] [ require true ]
     * @param  string $name 订单联系人 [ require true ]
     * @param  string $module 属于哪个模块 [ require true ]
     * @param  bool $use_today_shooting_sort 是否使用当日拍摄的排序 [ require true ]
     * @param  array $order_ids 订单ids [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDataUsePageV2 (array $store_id = [], array $user_id = [], array $product_id = [], array $status = [], array $pending_status = [], string $start_time = '', string $end_time = '', string $reserve_start_at = '', string $reserve_end_at = '', string $order_num = '', int $page = 1, string $name = '', string $module = 'himo', bool $use_today_shooting_sort = false, array $order_ids = [], int $page_size = 10) {
        return self::getClass()->getOrderDataUsePageV2([
            "store_id" => $store_id,
            "user_id" => $user_id,
            "product_id" => $product_id,
            "status" => $status,
            "pending_status" => $pending_status,
            "start_time" => $start_time,
            "end_time" => $end_time,
            "reserve_start_at" => $reserve_start_at,
            "reserve_end_at" => $reserve_end_at,
            "order_num" => $order_num,
            "page" => $page,
            "name" => $name,
            "module" => $module,
            "use_today_shooting_sort" => $use_today_shooting_sort,
            "order_ids" => $order_ids,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取门店拍历史摄数量
     *
     * @support  int $store_id 门店iD 
     * @support  bool $pendingCount pending数据 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPendingStatusWithCountV2 () {
        return self::getClass()->getOrderPendingStatusWithCountV2();
    }

    /**
     * 前台签到排队
     *
     * @support  int $order_id 订单id 
     * @support  int $staff_id 员工id 
     * @support  string $pending_status 无纸化状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function receptionistSignIn () {
        return self::getClass()->receptionistSignIn();
    }

    /**
     * 调整订单为等待化妆、等待摄影、或者挂起[done]
     *
     * @support  int $order_id 订单id 
     * @support  string $pending_status 无纸化状态 
     * @support  string $queue_type 队列类型 
     * @support  int $sort 队列排序 
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustOrderStatus () {
        return self::getClass()->adjustOrderStatus();
    }

    /**
     * 把订单指派给化妆师或者摄影师[done]
     *
     * @support  int $order_id 订单id 
     * @support  string $pending_status 无纸化状态 
     * @support  int $staff_id 伙伴id 
     * @support  string $source 来源 
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveOrderToStaff () {
        return self::getClass()->giveOrderToStaff();
    }

    /**
     * 获取无纸化当日拍摄订单id
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayShootingOrderIds () {
        return self::getClass()->getTodayShootingOrderIds();
    }

    /**
     * 摄影师完成订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $staff_id 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cameramanCompleteOrder () {
        return self::getClass()->cameramanCompleteOrder();
    }

    /**
     * 化妆师完成订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $staff_id 伙伴工号 [ require true ]
     * @support  string $comment 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function dresserCompleteOrder () {
        return self::getClass()->dresserCompleteOrder();
    }

    /**
     * 摄影师退回化妆
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $make_up_staff_id 上一个化妆师的id [ require true ]
     * @support  int $photographer_staff_id 摄影师id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToMakeUp () {
        return self::getClass()->returnToMakeUp();
    }

    /**
     * 完成选片
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $comment 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishSelectPhoto () {
        return self::getClass()->finishSelectPhoto();
    }

    /**
     * 获取伙伴当前的主单
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  string $staff_type 伙伴类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentWorkingOrders () {
        return self::getClass()->getCurrentWorkingOrders();
    }

    /**
     * 分配订单给辅助化妆师
     *
     * @support  array $to_staff_ids 伙伴ids [ require true ]
     * @support  int $order_id 伙伴类型 [ require true ]
     * @support  int $staff_id 分配者id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function giveOrderToStaffByDingDing () {
        return self::getClass()->giveOrderToStaffByDingDing();
    }

    /**
     * 清除所有无纸化相关的东西
     *
     * @support  int $order_id order_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearAllNoPaperInfo () {
        return self::getClass()->clearAllNoPaperInfo();
    }

    /**
     * 伙伴自动接单
     *
     * @param  int $taker 接单伙伴id [ require true ]
     * @param  string $pendingStatus 订单pending状态 [ require true ]
     * @param  int $storeId 门店iod [ require true ]
     * @param  string $queueType 队列类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function wsTakeOrder (int $taker, string $pendingStatus, int $storeId, string $queueType) {
        return self::getClass()->wsTakeOrder([
            "taker" => $taker,
            "pendingStatus" => $pendingStatus,
            "storeId" => $storeId,
            "queueType" => $queueType,
        ]);
    }

    /**
     * changeToWaitMakeUp
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeToWaitMakeUp () {
        return self::getClass()->changeToWaitMakeUp();
    }

    /**
     * 获取各个伙伴无纸化流程处理时间
     *
     * @support  array $order_ids 订单ids 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffProcessTimeByOrderIds () {
        return self::getClass()->getStaffProcessTimeByOrderIds();
    }

    /**
     * getLastDresser
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastDresser () {
        return self::getClass()->getLastDresser();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}