<?php
namespace Mainto\Bridge\Enums\Order;

class OrderStatusEnum {
    const NoPay = 'no_pay';
    const PART_PAYMENT = 'part_payment';
    const WaitShooting = 'wait_shooting';
    const Pending = 'pending';
    const StoreComplete = 'store_complete';
    const Complete = 'complete';
    const Close = 'close';
    const CloseByPay = 'close_by_pay';
    const CloseByNoPay = 'close_by_nopay';
    const CloseByRefund = 'close_by_refund';
    const TurnOut = 'turn_out';
    const WaitSign = 'wait_sign';
    const SignedInQueue = 'signed_in_queue';
    const WaitMakeUp = 'wait_make_up';
    const MakeUp = 'make_up';
    const WaitPhotography = 'wait_photography';
    const Photography = 'photography';
    const SelectPhoto = 'select_photo';
    const RepairLookPhoto = 'repair_look_photo';
    const alreadyHang = 'already_hang';
    const GROUP_STATE_ALL = [0 => 'no_pay',1 => 'wait_shooting',2 => 'pending',3 => 'complete',4 => 'close_by_refund',5 => 'close_by_nopay',6 => 'close_by_pay',7 => 'turn_out',8 => 'wait_sign',9 => 'signed_in_queue',10 => 'wait_make_up',11 => 'make_up',12 => 'photography',13 => 'select_photo',14 => 'repair_look_photo',15 => 'already_hang'];
    const GROUP_STATE_NORMAL = [0 => 'complete',1 => 'wait_shooting',2 => 'pending'];
    const NOT_ALLOW_REFUND_STATUS = [0 => 'no_pay',1 => 'turn_out',2 => 'close_by_refund',3 => 'close_by_pay',4 => 'close_by_nopay'];
    const ALLOW_USER_REFUND_STATUS = [0 => 'wait_shooting'];
    const NOT_ALLOW_INPUT_WORKLOAD = [0 => 'no_pay',1 => 'turn_out',2 => 'close_by_pay',3 => 'close_by_refund',4 => 'close_by_nopay'];
    const NOT_ALLOW_CHANGE_STORE = [0 => 'no_pay',1 => 'close_by_pay',2 => 'close_by_nopay',3 => 'close_by_refund',4 => 'turn_out'];
    const NOT_ALLOW_FINISH_ORDER = [0 => 'no_pay',1 => 'complete',2 => 'close_by_refund',3 => 'turn_out',4 => 'close_by_pay',5 => 'close_by_nopay'];
    const TODAY_SHOOTING_STATES = [0 => 'already_hang',1 => 'repair_look_photo',2 => 'select_photo',3 => 'photography',4 => 'wait_photography',5 => 'make_up',6 => 'wait_make_up',7 => 'signed_in_queue',8 => 'wait_sign'];
}