<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-03 16:51:41
 */
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Inventory
 */
class Inventory {
    private static string $serviceName = "OaProject";

    private static string $className = "Manage\\Inventory\\Inventory";

    /**
     * 新建盘点项目
     * @return  int
    */
    public static function create (string $name, string $type, string $remindType, int $remindValue, string $dailyPeriod, bool $showManage, array $configure) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "type" => $type, "remindType" => $remindType, "remindValue" => $remindValue, "dailyPeriod" => $dailyPeriod, "showManage" => $showManage, "configure" => $configure]);
    }
    /**
     * 盘点创建人列表
     * @return  array
    */
    public static function allCreator () {
        return RpcClass::getClass(self::$serviceName, self::$className)->allCreator();
    }
    /**
     * 盘点列表
     * @return  array
    */
    public static function all (int $staffId = 0, string $status, bool $withCount, string $name, array $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["staffId" => $staffId, "status" => $status, "withCount" => $withCount, "name" => $name, "type" => $type]);
    }
    /**
     * 存档
     * @return  bool
    */
    public static function stored (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stored(["inventoryId" => $inventoryId]);
    }
    /**
     * 修改盘点信息
     * @return  bool
    */
    public static function update (int $inventoryId, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["inventoryId" => $inventoryId, "name" => $name]);
    }
    /**
     * 删除盘点项
     * @return  bool
    */
    public static function delete (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["inventoryId" => $inventoryId]);
    }
    /**
     * 未评分通知
     * @return  mixed
    */
    public static function unSubmitNotify (int $inventoryId, array $fromStaffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unSubmitNotify(["inventoryId" => $inventoryId, "fromStaffIds" => $fromStaffIds]);
    }
    /**
     * 发送校准会通知
     * @return  bool
    */
    public static function sendWorkNotice (string $type, array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendWorkNotice(["type" => $type, "data" => $data]);
    }
    /**
     * HRBP查看盘点列表
     * @return  array
    */
    public static function getHrbpList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHrbpList();
    }
    /**
     * 完成盘点
     * @return  bool
    */
    public static function finish (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finish(["inventoryId" => $inventoryId]);
    }
    /**
     * 盘点列表[分页]
     * @return  mixed
    */
    public static function list (int $staffId = 0, int $page = 1, int $pageSize = 10, string $status, bool $withCount, string $name, array $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["staffId" => $staffId, "page" => $page, "pageSize" => $pageSize, "status" => $status, "withCount" => $withCount, "name" => $name, "type" => $type]);
    }
    /**
     * 盘点明细
     * @return  mixed
    */
    public static function detail (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["inventoryId" => $inventoryId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}