<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-02 10:45:26
 */
namespace Mainto\Bridge\Invokes\OaProject\User\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class InventoryRelation
 */
class InventoryRelation {
    private static string $serviceName = "OaProject";

    private static string $className = "User\\Inventory\\InventoryRelation";

    /**
     * 所有评分记录
     * @return  array
    */
    public static function all (int $inventoryId, bool $withCount, array $toStaffIds, string $staffKeyword) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["inventoryId" => $inventoryId, "withCount" => $withCount, "toStaffIds" => $toStaffIds, "staffKeyword" => $staffKeyword]);
    }
    /**
     * 被评人评分列表
     * @return  array
    */
    public static function getList (int $page = 1, int $pageSize = 20, bool $showMyself = false, string $assessMainType, int $inventoryId, string $assessType = 'management_ability_m1_m2', array $relationType, array $toStaffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList(["page" => $page, "pageSize" => $pageSize, "showMyself" => $showMyself, "assessMainType" => $assessMainType, "inventoryId" => $inventoryId, "assessType" => $assessType, "relationType" => $relationType, "toStaffIds" => $toStaffIds]);
    }
    /**
     * 导出被评人评分
     * @return  array
    */
    public static function exportRelationUsers (string $assessMainType = 'opinion_value', int $inventoryId, string $assessType = 'management_ability_m1_m2', array $relationType, array $toStaffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportRelationUsers(["assessMainType" => $assessMainType, "inventoryId" => $inventoryId, "assessType" => $assessType, "relationType" => $relationType, "toStaffIds" => $toStaffIds]);
    }
    /**
     * 打分预览统计(价值观)
     * @return  array
    */
    public static function previewOpinionValue (bool $showMyself = true, string $assessMainType, int $inventoryId, array $relationType, array $toStaffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->previewOpinionValue(["showMyself" => $showMyself, "assessMainType" => $assessMainType, "inventoryId" => $inventoryId, "relationType" => $relationType, "toStaffIds" => $toStaffIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}