<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-02 10:45:26
 */
namespace Mainto\Bridge\Invokes\OaProject\User\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Inventory
 */
class Inventory {
    private static string $serviceName = "OaProject";

    private static string $className = "User\\Inventory\\Inventory";

    /**
     * 参与的盘点
     * @return  array
    */
    public static function all () {
        return RpcClass::getClass(self::$serviceName, self::$className)->all();
    }
    /**
     * 是否在二次评分中
     * @return  bool
    */
    public static function isEvaluating (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isEvaluating(["inventoryId" => $inventoryId]);
    }
    /**
     * 我的盘点
     * @return  mixed
    */
    public static function list (int $toStaffId, int $page = 1, int $pageSize = 10, string $name, array $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["toStaffId" => $toStaffId, "page" => $page, "pageSize" => $pageSize, "name" => $name, "type" => $type]);
    }
    /**
     * 获取盘点结果
     * @return  array
    */
    public static function result (int $inventoryId, int $toStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->result(["inventoryId" => $inventoryId, "toStaffId" => $toStaffId]);
    }
    /**
     * 盘点明细
     * @return  mixed
    */
    public static function detail (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["inventoryId" => $inventoryId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}