<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-28 15:59:14
 */
namespace Mainto\Bridge\Invokes\OaProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "OaProject";

    private static string $className = "Manage\\Staff\\Staff";

    /**
     * 查询伙伴信息-返回伙伴基础信息和职位信息 无条件 则返回空
     * @return  mixed
    */
    public static function all (bool $with_delete = false, array $staff_ids, array $dept_ids, array $position_ids, bool $only_delete = false, string $keyword) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["with_delete" => $with_delete, "staff_ids" => $staff_ids, "dept_ids" => $dept_ids, "position_ids" => $position_ids, "only_delete" => $only_delete, "keyword" => $keyword]);
    }
    /**
     * 工号花名姓名搜索
     * @return  mixed
    */
    public static function keywordSearch (string $keyword) {
        return RpcClass::getClass(self::$serviceName, self::$className)->keywordSearch(["keyword" => $keyword]);
    }
    /**
     * 检测工号可用
     * @return  mixed
    */
    public static function checkStaffActive (array $staff_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkStaffActive(["staff_ids" => $staff_ids]);
    }
    /**
     * 新增伙伴
     * @return  int
    */
    public static function create (int $id, string $status, string $type, string $entry_at, string $positive_at, string $rest_type, string $remark, string $attribute, string $job_title, string $job_type, int $create_nas, array $personal_info, array $contract_info, array $education_info, array $experience_info, array $annex) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["id" => $id, "status" => $status, "type" => $type, "entry_at" => $entry_at, "positive_at" => $positive_at, "rest_type" => $rest_type, "remark" => $remark, "attribute" => $attribute, "job_title" => $job_title, "job_type" => $job_type, "create_nas" => $create_nas, "personal_info" => $personal_info, "contract_info" => $contract_info, "education_info" => $education_info, "experience_info" => $experience_info, "annex" => $annex]);
    }
    /**
     * 更新
     * @return  bool
    */
    public static function update (int $id, string $status, string $type, string $positive_at, string $rest_type, string $remark, int $department_id, int $position_id, string $level, string $attribute, string $job_title, string $job_type, array $personal_info, array $annex, int $create_nas) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "status" => $status, "type" => $type, "positive_at" => $positive_at, "rest_type" => $rest_type, "remark" => $remark, "department_id" => $department_id, "position_id" => $position_id, "level" => $level, "attribute" => $attribute, "job_title" => $job_title, "job_type" => $job_type, "personal_info" => $personal_info, "annex" => $annex, "create_nas" => $create_nas]);
    }
    /**
     * 离职
     * @return  bool
    */
    public static function leave (int $id, string $leave_at, string $leave_reason = null, string $leave_remark = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->leave(["id" => $id, "leave_at" => $leave_at, "leave_reason" => $leave_reason, "leave_remark" => $leave_remark]);
    }
    /**
     * 复职
     * @return  int
    */
    public static function goBack (int $id, string $status, string $type, string $positive_at, string $rest_type, string $remark, string $attribute, string $job_title, string $job_type, array $personal_info, array $annex, int $create_nas) {
        return RpcClass::getClass(self::$serviceName, self::$className)->goBack(["id" => $id, "status" => $status, "type" => $type, "positive_at" => $positive_at, "rest_type" => $rest_type, "remark" => $remark, "attribute" => $attribute, "job_title" => $job_title, "job_type" => $job_type, "personal_info" => $personal_info, "annex" => $annex, "create_nas" => $create_nas]);
    }
    /**
     * 获取员工密码
     * @return  mixed
    */
    public static function getPassInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPassInfo();
    }
    /**
     * 员工详情
     * @return  array
    */
    public static function getOne (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOne(["id" => $id]);
    }
    /**
     * 获取时间段内的转正员工id
     * @return  array
    */
    public static function getStaffIdByPositiveAt (string $positiveAtStart, string $positiveAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdByPositiveAt(["positiveAtStart" => $positiveAtStart, "positiveAtEnd" => $positiveAtEnd]);
    }
    /**
     * 分批获取转正员工id
     * @return  array
    */
    public static function getAllRegularStaffIdsByPage (int $page, int $perPage = 300) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllRegularStaffIdsByPage(["page" => $page, "perPage" => $perPage]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}