<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method correctByParams(array $params)
 * @method cancelCorrectByParams(array $params)
 * @method statusByParams(array $params)
 * @method finalCalcByParams(array $params)
 */
class InventoryStatistic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 评分统计
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  array $toStaffIds 被评员工id [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @support  string $status 评分类型 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 纠偏
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function correct (int $inventoryId) {
        return self::getClass()->correct([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 撤销纠偏
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelCorrect (int $inventoryId) {
        return self::getClass()->cancelCorrect([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 计算状态
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function status (int $inventoryId) {
        return self::getClass()->status([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 系统计算最终得分
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function finalCalc (int $inventoryId) {
        return self::getClass()->finalCalc([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryStatistic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryStatistic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}