<?php
namespace Mainto\Bridge\Invokes\OaProject\User\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method submitBatchByParams(array $params)
 * @method listByParams(array $params)
 */
class InventoryRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 评分详情
     *
     * @param  int $relationId 关联关系id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $relationId) {
        return self::getClass()->detail([
            "relationId" => $relationId,
        ]);
    }

    /**
     * 提交评分
     *
     * @param  int $inventoryRelationId 评分关系id [ require true ]
     * @param  array $submitItems 提交信息 [ require true ]
     * @param  bool $isStash 暂存 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $inventoryRelationId, array $submitItems, bool $isStash = false) {
        return self::getClass()->create([
            "inventoryRelationId" => $inventoryRelationId,
            "submitItems" => $submitItems,
            "isStash" => $isStash,
        ]);
    }

    /**
     * 批量提交评分
     *
     * @param  array $data 批量提交数据 [ require true ]
     * @param  bool $isStash 暂存 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $data, bool $isStash = false) {
        return self::getClass()->batchCreate([
            "data" => $data,
            "isStash" => $isStash,
        ]);
    }

    /**
     * 一键提交
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function submitBatch () {
        return self::getClass()->submitBatch();
    }

    /**
     * 评分记录列表
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  int $toStaffId 被盘点人工号 [ require true ]
     * @param  string $assessType 评价类型 [ require false ]
     * @param  int $fromStaffId 登录人工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $inventoryId, int $toStaffId, int $fromStaffId, string $assessType = 'opinion_value') {
        return self::getClass()->list([
            "inventoryId" => $inventoryId,
            "toStaffId" => $toStaffId,
            "fromStaffId" => $fromStaffId,
            "assessType" => $assessType,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'User\Inventory\InventoryRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'User\Inventory\InventoryRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}