<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createBatchByParams(array $params)
 * @method listByParams(array $params)
 * @method notAssessedByParams(array $params)
 * @method restartByParams(array $params)
 */
class InventoryRelation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存伙伴关系
     *
     * @param  int $toStaffId 伙伴id [ require true ]
     * @param  string $inventoryRange 序列 [ require true ]
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  array $assessItems 配置 [ require true ]
     * @param  int $hrbp HRBP工号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $toStaffId, int $inventoryId, array $assessItems, string $inventoryRange, int $hrbp = null) {
        return self::getClass()->create([
            "toStaffId" => $toStaffId,
            "inventoryId" => $inventoryId,
            "assessItems" => $assessItems,
            "inventoryRange" => $inventoryRange,
            "hrbp" => $hrbp,
        ]);
    }

    /**
     * 批量提交
     *
     * @param  array $relations 配置信息 [ require true ]
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createBatch (array $relations, int $inventoryId) {
        return self::getClass()->createBatch([
            "relations" => $relations,
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 获取已配置的评价关系列表
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  array $fromStaffIds 评价人伙伴ids [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页码 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取伙伴还未 完成评价关系列表
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  array $toStaffIds 伙伴ids [ require false ]
     * @support  array $fromStaffIds 伙伴ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function notAssessed (int $inventoryId) {
        return self::getClass()->notAssessed([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 退回重评
     *
     * @param  int $inventoryRelationId 盘点评分配置id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function restart (int $inventoryRelationId) {
        return self::getClass()->restart([
            "inventoryRelationId" => $inventoryRelationId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryRelation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryRelation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}