<?php
namespace Mainto\Bridge\Enums\OaProject\Inventory;

class InventoryRelationStatusEnum {
    /**
     * 未配置
     */
    const DEFAULT = 'default';
    /**
     * 已配置
     */
    const CREATED = 'created';
    /**
     * 二次开启(复评中)
     */
    const START_TWICE = 'start_twice';
    /**
     * 已开启
     */
    const STARTED = 'started';
    /**
     * 暂存
     */
    const STASHED = 'stashed';
    /**
     * 评分完成
     */
    const ASSESSED = 'assessed';
    /**
     * 复核完成
     */
    const REVIEWED = 'reviewed';
    /**
     * 重评
     */
    const RESTARTED = 'restarted';
    /**
     * 已归档
     */
    const STORED = 'stored';
    /**
     * 统计值映射
     */
    const COUNT_MAP = ['created' => 'created','started' => 'started','assessed' => 'assessed','reviewed' => 'assessed','stored' => 'stored','restarted' => 'restarted','stashed' => 'stashed','start_twice' => 'start_twice'];
    /**
     * 还未评价完成
     */
    const NOT_ASSESSED = [0 => 'started',1 => 'stashed',2 => 'restarted',3 => 'start_twice'];
    /**
     * 展示用户(未评价.已评价.未归档)
     */
    const QUERY_USER_SHOW = [0 => 'started',1 => 'stashed',2 => 'reviewed',3 => 'restarted',4 => 'assessed',5 => 'start_twice'];
    const ALL = [0 => 'created',1 => 'started',2 => 'assessed',3 => 'reviewed',4 => 'stored',5 => 'restarted',6 => 'stashed',7 => 'start_twice'];
    const NAME_MAP = ['start_twice' => '复评中','started' => '待评分','restarted' => '重评中','stashed' => '暂存中','assessed' => '已评分','reviewed' => '已复核','stored' => '已归档','created' => '已配置','default' => '未配置'];
}