<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffsByParams(array $params)
 * @method createByParams(array $params)
 * @method cancelByParams(array $params)
 * @method finishByParams(array $params)
 * @method acceptByParams(array $params)
 * @method initiatedListByParams(array $params)
 * @method unreceivedListByParams(array $params)
 * @method pendingListByParams(array $params)
 * @method unreceivedStatisticsByParams(array $params)
 */
class Pluralism {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 工号花名姓名搜索可操作兼岗的伙伴
     *
     * @param  string $keyword 工号|花名|姓名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffs (string $keyword) {
        return self::getClass()->getStaffs([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 发起兼岗
     *
     * @param  int $staff_id 伙伴ID [ require true ]
     * @param  int $job_id 职位ID [ require true ]
     * @param  int $pluralism_store_id 兼岗门店ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (int $staff_id, int $job_id, int $pluralism_store_id) {
        return self::getClass()->create([
            "staff_id" => $staff_id,
            "job_id" => $job_id,
            "pluralism_store_id" => $pluralism_store_id,
        ]);
    }

    /**
     * 撤回兼岗
     *
     * @param  int $pluralism_id 兼岗id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel (int $pluralism_id) {
        return self::getClass()->cancel([
            "pluralism_id" => $pluralism_id,
        ]);
    }

    /**
     * 取消兼岗
     *
     * @param  int $pluralism_id 兼岗id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function finish (int $pluralism_id) {
        return self::getClass()->finish([
            "pluralism_id" => $pluralism_id,
        ]);
    }

    /**
     * 接收兼岗
     *
     * @param  int $pluralism_id 兼岗id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function accept (int $pluralism_id) {
        return self::getClass()->accept([
            "pluralism_id" => $pluralism_id,
        ]);
    }

    /**
     * 已发起的兼岗列表
     *
     * @param  string $search 搜索条件 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function initiatedList (string $search = '', int $page = 1, int $page_size = 20) {
        return self::getClass()->initiatedList([
            "search" => $search,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 待接收的兼岗列表
     *
     * @param  string $search 搜索条件 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function unreceivedList (string $search = '', int $page = 1, int $page_size = 20) {
        return self::getClass()->unreceivedList([
            "search" => $search,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 兼岗中的兼岗列表
     *
     * @param  string $search 搜索条件 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function pendingList (string $search = '', int $page = 1, int $page_size = 20) {
        return self::getClass()->pendingList([
            "search" => $search,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取未接收的兼岗数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function unreceivedStatistics () {
        return self::getClass()->unreceivedStatistics();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Staff\Pluralism');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Staff\Pluralism');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}