<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method toStaffListByParams(array $params)
 * @method listByParams(array $params)
 * @method startByParams(array $params)
 * @method startBatchByParams(array $params)
 * @method closeByParams(array $params)
 * @method closeBatchByParams(array $params)
 * @method startDirectSupervisorBatchByParams(array $params)
 * @method reviewByParams(array $params)
 * @method reviewBatchByParams(array $params)
 * @method startTwiceByParams(array $params)
 */
class InventoryStaff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 应被评价的伙伴
     *
     * @support  string $type 列表项 [ require false ]
     * @support  int $inventoryId 盘点项 [ require false ]
     * @support  array $staffIds 伙伴ids [ require false ]
     * @param  bool $withDepartmentDetail 是否包含完整部门信息 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function toStaffList (bool $withDepartmentDetail = false, int $page = 1, int $pageSize = 10) {
        return self::getClass()->toStaffList([
            "withDepartmentDetail" => $withDepartmentDetail,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点伙伴列表
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  array $staffIds 伙伴id组 [ require false ]
     * @support  string $status 状态位 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 开启评分
     *
     * @param  int $inventoryStaffId 盘点伙伴关联id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function start (int $inventoryStaffId) {
        return self::getClass()->start([
            "inventoryStaffId" => $inventoryStaffId,
        ]);
    }

    /**
     * 一键开启评分
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  array $toStaffIds 员工id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startBatch (int $inventoryId) {
        return self::getClass()->startBatch([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 关闭评分
     *
     * @param  int $inventoryStaffId 盘点伙伴关联id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $inventoryStaffId) {
        return self::getClass()->close([
            "inventoryStaffId" => $inventoryStaffId,
        ]);
    }

    /**
     * 一键关闭评分
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  array $staffIds 伙伴ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeBatch (int $inventoryId) {
        return self::getClass()->closeBatch([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 一键开启上级评分
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  array $toStaffIds 员工id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startDirectSupervisorBatch (int $inventoryId, array $toStaffIds = []) {
        return self::getClass()->startDirectSupervisorBatch([
            "inventoryId" => $inventoryId,
            "toStaffIds" => $toStaffIds,
        ]);
    }

    /**
     * 复核
     *
     * @param  int $inventoryStaffId 盘点伙伴关联id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function review (int $inventoryStaffId) {
        return self::getClass()->review([
            "inventoryStaffId" => $inventoryStaffId,
        ]);
    }

    /**
     * 批量复核
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @support  array $toStaffIds 员工id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewBatch (int $inventoryId) {
        return self::getClass()->reviewBatch([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 开启二次评分
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function startTwice (int $inventoryId) {
        return self::getClass()->startTwice([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryStaff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryStaff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}