<?php
namespace Mainto\Bridge\Invokes\OaProject\User\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveByParams(array $params)
 * @method submitByParams(array $params)
 * @method detailByParams(array $params)
 */
class InventoryAppeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 申诉保存
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  string $content 申诉内容 [ require true ]
     * @param  int $toStaffId 登录人工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function save (int $inventoryId, int $toStaffId, string $content) {
        return self::getClass()->save([
            "inventoryId" => $inventoryId,
            "toStaffId" => $toStaffId,
            "content" => $content,
        ]);
    }

    /**
     * 申诉提交
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  string $content 申诉内容 [ require false ]
     * @param  int $toStaffId 登录人工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $inventoryId, int $toStaffId, string $content = '') {
        return self::getClass()->submit([
            "inventoryId" => $inventoryId,
            "toStaffId" => $toStaffId,
            "content" => $content,
        ]);
    }

    /**
     * 申诉详情
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  int $toStaffId 登录人工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $toStaffId, int $inventoryId) {
        return self::getClass()->detail([
            "toStaffId" => $toStaffId,
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'User\Inventory\InventoryAppeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'User\Inventory\InventoryAppeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}