<?php
namespace Mainto\Bridge\Enums\OaProject\Inventory;

class InventoryStaffStatusEnum {
    /**
     * 未配置
     */
    const DEFAULT = 'default';
    /**
     * 已配置
     */
    const CREATED = 'created';
    /**
     * 已开启
     */
    const STARTED = 'started';
    /**
     * 二次开启(复评中)
     */
    const START_TWICE = 'start_twice';
    /**
     * 已评价
     */
    const ASSESSED = 'assessed';
    /**
     * 已复核
     */
    const REVIEWED = 'reviewed';
    /**
     * 已归档
     */
    const STORED = 'stored';
    /**
     * 申诉中
     */
    const APPEALING = 'appealing';
    const ALL = [0 => 'created',1 => 'started',2 => 'stored',3 => 'reviewed',4 => 'assessed',5 => 'start_twice'];
    const STARTED_ALL = [0 => 'started',1 => 'stored',2 => 'reviewed',3 => 'assessed',4 => 'start_twice',5 => 'appealing'];
    const QUERY_MAP = ['created' => [0 => 'created'],'started' => [0 => 'started',1 => 'reviewed',2 => 'assessed',3 => 'start_twice']];
    /**
     * 允许复核的状态
     */
    const ALLOW_REVIEW = [0 => 'assessed',1 => 'start_twice'];
}