<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method openByParams(array $params)
 * @method completeByParams(array $params)
 * @method autoCompleteByParams(array $params)
 */
class InventoryAppeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 申诉开启
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  string $appealAt 截止时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function open (int $inventoryId, string $appealAt) {
        return self::getClass()->open([
            "inventoryId" => $inventoryId,
            "appealAt" => $appealAt,
        ]);
    }

    /**
     * 申诉完成
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function complete (int $inventoryId) {
        return self::getClass()->complete([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 申诉定时关闭
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoComplete () {
        return self::getClass()->autoComplete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryAppeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryAppeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}