<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method createBatchByParams(array $params)
 */
class InventoryScale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 评分占比关系
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $inventoryId) {
        return self::getClass()->all([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 创建占比关系
     *
     * @param  int $inventoryId 盘点id [ require true ]
     * @param  array $scaleItems 占比信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createBatch (int $inventoryId, array $scaleItems) {
        return self::getClass()->createBatch([
            "inventoryId" => $inventoryId,
            "scaleItems" => $scaleItems,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryScale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryScale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}