<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 */
class InventoryRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 评分详情
     *
     * @support  int $inventory_staff_id 盘点伙伴关联id [ require false ]
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  int $from_staff_id 评价人 [ require false ]
     * @param  bool $with_count 统计得分 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $inventory_id, bool $with_count = false) {
        return self::getClass()->detail([
            "inventory_id" => $inventory_id,
            "with_count" => $with_count,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}