<?php
namespace Mainto\Bridge\Invokes\OaProject\User\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method submitBatchByParams(array $params)
 */
class InventoryRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 评分详情
     *
     * @param  int $relation_id 关联关系id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $relation_id) {
        return self::getClass()->detail([
            "relation_id" => $relation_id,
        ]);
    }

    /**
     * 提交评分
     *
     * @param  int $inventory_relation_id 评分关系id [ require true ]
     * @param  array $submit_items 提交信息 [ require true ]
     * @param  bool $is_stash 暂存 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $inventory_relation_id, array $submit_items, bool $is_stash = false) {
        return self::getClass()->create([
            "inventory_relation_id" => $inventory_relation_id,
            "submit_items" => $submit_items,
            "is_stash" => $is_stash,
        ]);
    }

    /**
     * 批量提交评分
     *
     * @param  array $data 批量提交数据 [ require true ]
     * @param  bool $is_stash 批量提交数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $data, bool $is_stash = false) {
        return self::getClass()->batchCreate([
            "data" => $data,
            "is_stash" => $is_stash,
        ]);
    }

    /**
     * 一键提交
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function submitBatch () {
        return self::getClass()->submitBatch();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'User\Inventory\InventoryRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'User\Inventory\InventoryRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}