<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createBatchByParams(array $params)
 * @method listByParams(array $params)
 * @method notAssessedByParams(array $params)
 * @method restartByParams(array $params)
 */
class InventoryRelation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存伙伴关系
     *
     * @param  int $to_staff_id 伙伴id [ require true ]
     * @param  string $inventory_range 序列 [ require true ]
     * @param  int $inventory_id 盘点id [ require true ]
     * @param  array $assess_items 配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $to_staff_id, int $inventory_id, array $assess_items, string $inventory_range) {
        return self::getClass()->create([
            "to_staff_id" => $to_staff_id,
            "inventory_id" => $inventory_id,
            "assess_items" => $assess_items,
            "inventory_range" => $inventory_range,
        ]);
    }

    /**
     * 批量提交
     *
     * @param  array $relations 配置信息 [ require true ]
     * @param  int $inventory_id 盘点id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createBatch (array $relations, int $inventory_id) {
        return self::getClass()->createBatch([
            "relations" => $relations,
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 获取已配置的评价关系列表
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  array $from_staff_ids 评价人伙伴ids require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 页码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $inventory_id, int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "inventory_id" => $inventory_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取伙伴还未 完成评价关系列表
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  array $to_staff_ids 伙伴ids require false
     * @support  array $from_staff_ids 伙伴ids require false
     * @throws  \Exception
     * @return  array
     */
    public static function notAssessed (int $inventory_id) {
        return self::getClass()->notAssessed([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 退回重评
     *
     * @param  int $inventory_relation_id 盘点评分配置id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function restart (int $inventory_relation_id) {
        return self::getClass()->restart([
            "inventory_relation_id" => $inventory_relation_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryRelation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryRelation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}