<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method toStaffListByParams(array $params)
 * @method listByParams(array $params)
 * @method startByParams(array $params)
 * @method startBatchByParams(array $params)
 * @method closeByParams(array $params)
 * @method closeBatchByParams(array $params)
 * @method reviewByParams(array $params)
 * @method reviewBatchByParams(array $params)
 * @method startTwiceByParams(array $params)
 */
class InventoryStaff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 应被评价的伙伴
     *
     * @support  string $type 列表项 require false
     * @support  int $inventory_id 盘点项 require false
     * @support  array $staff_ids 伙伴ids require false
     * @param  bool $with_department_detail 是否包含完整部门信息 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function toStaffList (bool $with_department_detail = false, int $page = 1, int $page_size = 10) {
        return self::getClass()->toStaffList([
            "with_department_detail" => $with_department_detail,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 盘点伙伴列表
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  array $staff_ids 伙伴id组 require false
     * @support  string $status 状态位 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $inventory_id, int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "inventory_id" => $inventory_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 开启评分
     *
     * @param  int $inventory_staff_id 盘点伙伴关联id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function start (int $inventory_staff_id) {
        return self::getClass()->start([
            "inventory_staff_id" => $inventory_staff_id,
        ]);
    }

    /**
     * 一键开启评分
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  array $to_staff_ids 员工id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function startBatch (int $inventory_id) {
        return self::getClass()->startBatch([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 关闭评分
     *
     * @param  int $inventory_staff_id 盘点伙伴关联id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $inventory_staff_id) {
        return self::getClass()->close([
            "inventory_staff_id" => $inventory_staff_id,
        ]);
    }

    /**
     * 一键关闭评分
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  array $staff_ids 伙伴ids require false
     * @throws  \Exception
     * @return  bool
     */
    public static function closeBatch (int $inventory_id) {
        return self::getClass()->closeBatch([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 复核
     *
     * @param  int $inventory_staff_id 盘点伙伴关联id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function review (int $inventory_staff_id) {
        return self::getClass()->review([
            "inventory_staff_id" => $inventory_staff_id,
        ]);
    }

    /**
     * 批量复核
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  array $to_staff_ids 员工id require false
     * @support  string $status 状态 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewBatch (int $inventory_id) {
        return self::getClass()->reviewBatch([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 开启二次评分
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function startTwice (int $inventory_id) {
        return self::getClass()->startTwice([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryStaff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryStaff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}