<?php
namespace Mainto\Bridge\Invokes\OaProject\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpyunSignByParams(array $params)
 * @method notifyByParams(array $params)
 */
class Upyun {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @param  bool $isDown isDown [ require true ]
     * @param  string $contentLength contentLength 用于大文件上传 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign (string $upyun_key, bool $isDown = false, string $contentLength = '') {
        return self::getClass()->getUpyunSign([
            "upyun_key" => $upyun_key,
            "isDown" => $isDown,
            "contentLength" => $contentLength,
        ]);
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function notify () {
        return self::getClass()->notify();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Common\Upyun');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Common\Upyun');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}