<?php
namespace Mainto\Bridge\Invokes\OaProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method typeListByParams(array $params)
 */
class Feedback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交反馈
     *
     * @param  string $type 反馈类型 [ require true ]
     * @param  string $content 反馈内容 [ require true ]
     * @support  array $image_path 图片路径 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $type, string $content) {
        return self::getClass()->create([
            "type" => $type,
            "content" => $content,
        ]);
    }

    /**
     * 根据伙伴获取反馈列表
     *
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取反馈详情
     *
     * @param  int $id 反馈记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 反馈类型列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function typeList () {
        return self::getClass()->typeList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'User\Feedback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'User\Feedback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}