<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method keywordSearchByParams(array $params)
 * @method checkStaffActiveByParams(array $params)
 * @method configListByParams(array $params)
 * @method levelListByParams(array $params)
 * @method contractSubjectListByParams(array $params)
 * @method createByParams(array $params)
 * @method turnPositiveByParams(array $params)
 * @method updateByParams(array $params)
 * @method leaveByParams(array $params)
 * @method goBackByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method updateStaffAttributeByParams(array $params)
 * @method getStaffIdsAlreadyPositiveByParams(array $params)
 * @method getBankByNumberByParams(array $params)
 * @method searchBankBranchesByParams(array $params)
 * @method getPassInfoByParams(array $params)
 * @method getOneByParams(array $params)
 * @method getStaffIdByPositiveAtByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询伙伴信息-返回伙伴基础信息和职位信息 无条件 则返回空
     *
     * @support  array $staff_ids 工号ids require false
     * @support  array $dept_ids 部门ids require false
     * @support  array $position_ids 职位ids require false
     * @param  bool $with_delete 包含离职 [ require true ]
     * @support  bool $only_delete 只要离职 require false
     * @support  string $keyword 工号|花名|姓名 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function all (bool $with_delete = false) {
        return self::getClass()->all([
            "with_delete" => $with_delete,
        ]);
    }

    /**
     * 工号花名姓名搜索
     *
     * @param  string $keyword 工号|花名|姓名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function keywordSearch (string $keyword) {
        return self::getClass()->keywordSearch([
            "keyword" => $keyword,
        ]);
    }

    /**
     * 检测工号可用
     *
     * @param  array $staff_ids 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkStaffActive (array $staff_ids) {
        return self::getClass()->checkStaffActive([
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * 配置列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function configList () {
        return self::getClass()->configList();
    }

    /**
     * 职级列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function levelList () {
        return self::getClass()->levelList();
    }

    /**
     * 合同主体列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function contractSubjectList () {
        return self::getClass()->contractSubjectList();
    }

    /**
     * 新增伙伴
     *
     * @support  int $id 伙伴id [ require true ]
     * @support  string $status 员工状态 [ require true ]
     * @support  string $type 员工类型 [ require true ]
     * @support  string $entry_at 入职日期 [ require true ]
     * @support  string $positive_at 转正日期 [ require true ]
     * @support  string $rest_type 休息类型 require false
     * @support  string $remark 备注 require false
     * @support  string $attribute 伙伴属性(自有或加盟) [ require true ]
     * @support  string $job_title 技术职称 require false
     * @support  string $job_type 工作组(组长或无) require false
     * @support  int $create_nas 创建NAS require false
     * @support  array $personal_info 个人其他信息 [ require true ]
     * @support  array $contract_info 合同信息 require false
     * @support  array $education_info 学历信息 require false
     * @support  array $experience_info 工作经历信息 require false
     * @support  array $annex 附件 require false
     * @throws  \Exception
     * @return  int
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 转正定时任务
     *
     * @throws  \Exception
     * @return  void
     */
    public static function turnPositive () {
        return self::getClass()->turnPositive();
    }

    /**
     * 更新
     *
     * @param  int $id 工号 [ require true ]
     * @support  string $status 员工状态 require false
     * @support  string $type 员工类型 require false
     * @support  string $positive_at 转正日期 require false
     * @support  string $rest_type 休息类型 require false
     * @support  string $remark 备注 require false
     * @support  int $department_id 部门id require false
     * @support  int $position_id 职位id require false
     * @support  string $level 职级 require false
     * @support  string $attribute 伙伴属性(自有或加盟) require false
     * @support  string $job_title 技术职称 require false
     * @support  string $job_type 工作组(组长或无) require false
     * @support  array $personal_info 个人其他信息 require false
     * @support  array $annex 附件 require false
     * @support  int $create_nas 创建NAS require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 离职
     *
     * @param  int $id 工号 [ require true ]
     * @param  string $leave_at 离职时间 [ require true ]
     * @param  string $leave_reason 离职原因 [ require true ]
     * @param  string $leave_remark 离职备注 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function leave (int $id, string $leave_at, string $leave_reason = null, string $leave_remark = null) {
        return self::getClass()->leave([
            "id" => $id,
            "leave_at" => $leave_at,
            "leave_reason" => $leave_reason,
            "leave_remark" => $leave_remark,
        ]);
    }

    /**
     * 复职
     *
     * @param  int $id 工号 [ require true ]
     * @support  string $status 员工状态 require false
     * @support  string $type 员工类型 require false
     * @support  string $positive_at 转正日期 require false
     * @support  string $rest_type 休息类型 require false
     * @support  string $remark 备注 require false
     * @support  string $attribute 伙伴属性(自有或加盟) require false
     * @support  string $job_title 技术职称 require false
     * @support  string $job_type 工作组(组长或无) require false
     * @support  array $personal_info 个人其他信息 require false
     * @support  array $annex 附件 require false
     * @support  int $create_nas 创建NAS require false
     * @throws  \Exception
     * @return  int
     */
    public static function goBack (int $id) {
        return self::getClass()->goBack([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 require false
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 门店属性发生更改时,同步员工属性
     *
     * @param  array $original 原数据 [ require true ]
     * @param  array $attributes 更新后数据 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function updateStaffAttribute (array $original, array $attributes) {
        return self::getClass()->updateStaffAttribute([
            "original" => $original,
            "attributes" => $attributes,
        ]);
    }

    /**
     * 根据条件获得已转正的staffIds
     *
     * @param  string $positiveBegin 转正开始时间 [ require true ]
     * @param  string $positiveEnd 转正结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdsAlreadyPositive (string $positiveBegin = '', string $positiveEnd = '') {
        return self::getClass()->getStaffIdsAlreadyPositive([
            "positiveBegin" => $positiveBegin,
            "positiveEnd" => $positiveEnd,
        ]);
    }

    /**
     * 获取所属银行
     *
     * @param  string $bankNumber 银行卡号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBankByNumber (string $bankNumber) {
        return self::getClass()->getBankByNumber([
            "bankNumber" => $bankNumber,
        ]);
    }

    /**
     * 获取银行支行
     *
     * @param  string $bankName 银行名称 [ require true ]
     * @param  string $name 支行名称 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchBankBranches (string $bankName, string $name, int $page = 1, int $pageSize = 10) {
        return self::getClass()->searchBankBranches([
            "bankName" => $bankName,
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取员工密码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPassInfo () {
        return self::getClass()->getPassInfo();
    }

    /**
     * 员工详情
     *
     * @param  int $id 工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOne (int $id) {
        return self::getClass()->getOne([
            "id" => $id,
        ]);
    }

    /**
     * 获取时间段内的转正员工id
     *
     * @param  string $positiveAtStart 开始时间 [ require true ]
     * @param  string $positiveAtEnd 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdByPositiveAt (string $positiveAtStart, string $positiveAtEnd) {
        return self::getClass()->getStaffIdByPositiveAt([
            "positiveAtStart" => $positiveAtStart,
            "positiveAtEnd" => $positiveAtEnd,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Staff\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Staff\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}