<?php
namespace Mainto\Bridge\Invokes\OaProject\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllGroupsByParams(array $params)
 * @method createGroupByParams(array $params)
 * @method editGroupByParams(array $params)
 * @method onGroupUpdatedByParams(array $params)
 * @method onGroupDeletedByParams(array $params)
 * @method onGroupCreatedByParams(array $params)
 * @method onStaffUpdateByParams(array $params)
 */
class Group {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有分组【不分页】
     *
     * @param  string $application 来源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllGroups (string $application) {
        return self::getClass()->getAllGroups([
            "application" => $application,
        ]);
    }

    /**
     * 创建组
     *
     * @support  string $groupName 组名 [ require true ]
     * @support  int $groupType 分组类型 1:部门 2：职位 3： 职级 [ require true ]
     * @param  string $application 应用 [ require true ]
     * @support  array $typeKey 分组类型键 require false
     * @support  array $extraStaff 额外用户 require false
     * @support  array $excludeStaff 去除用户 require false
     * @support  array $extend 额外信息 require false
     * @support  string $desc 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createGroup (string $application) {
        return self::getClass()->createGroup([
            "application" => $application,
        ]);
    }

    /**
     * 修改组
     *
     * @support  int $groupId 分组ID [ require true ]
     * @support  string $groupName 分组名称 require false
     * @support  int $groupType 分组类型 require false
     * @support  array $typeKey 类型键 require false
     * @support  array $extraStaff 额外添加人 require false
     * @support  array $excludeStaff 排除的人 require false
     * @support  array $extend 其他配置参数 require false
     * @support  string $desc 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editGroup () {
        return self::getClass()->editGroup();
    }

    /**
     * 分组更新
     *
     * @param  int $groupId 分组id [ require true ]
     * @param  string $application 应用名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onGroupUpdated (int $groupId, string $application) {
        return self::getClass()->onGroupUpdated([
            "groupId" => $groupId,
            "application" => $application,
        ]);
    }

    /**
     * 分组删除
     *
     * @param  int $groupId 分组id [ require true ]
     * @param  string $application 应用名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onGroupDeleted (int $groupId, string $application) {
        return self::getClass()->onGroupDeleted([
            "groupId" => $groupId,
            "application" => $application,
        ]);
    }

    /**
     * 分组创建
     *
     * @param  int $groupId 分组id [ require true ]
     * @param  string $application 应用名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onGroupCreated (int $groupId, string $application) {
        return self::getClass()->onGroupCreated([
            "groupId" => $groupId,
            "application" => $application,
        ]);
    }

    /**
     * 伙伴信息变更
     *
     * @param  array $old_staff 旧信息 [ require true ]
     * @param  array $new_staff 新信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function onStaffUpdate (array $old_staff, array $new_staff) {
        return self::getClass()->onStaffUpdate([
            "old_staff" => $old_staff,
            "new_staff" => $new_staff,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Common\Group');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Common\Group');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}