<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 */
class InventoryShow {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 导入最终绘图数据
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @param  array $draw_data 数据信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $inventory_id, array $draw_data) {
        return self::getClass()->create([
            "inventory_id" => $inventory_id,
            "draw_data" => $draw_data,
        ]);
    }

    /**
     * 获取绘图数据
     *
     * @param  int $inventory_id 盘点id [ require true ]
     * @support  string $range 序列 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $inventory_id) {
        return self::getClass()->list([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\InventoryShow');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\InventoryShow');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}