<?php
namespace Mainto\Bridge\Invokes\OaProject\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffsByStaffIdsByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过工号获取伙伴信息
     *
     * @param  array $staffIds 工号ids [ require true ]
     * @param  bool $withDelete 包含离职 [ require true ]
     * @param  string $apiKey api key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffsByStaffIds (array $staffIds, string $apiKey, bool $withDelete = false) {
        return self::getClass()->getStaffsByStaffIds([
            "staffIds" => $staffIds,
            "apiKey" => $apiKey,
            "withDelete" => $withDelete,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Api\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Api\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}