<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Satisfaction;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createTemplateByParams(array $params)
 * @method updateTemplateByParams(array $params)
 * @method deleteTemplateByParams(array $params)
 * @method getTemplateListByParams(array $params)
 * @method getTemplateDetailByParams(array $params)
 * @method getTemplateIdByNameByParams(array $params)
 * @method createTemplateScoreByParams(array $params)
 * @method deleteTemplateScoreByParams(array $params)
 * @method getTemplateScoreListByParams(array $params)
 */
class SatisfactionTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $items 配置信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createTemplate (string $name, array $items) {
        return self::getClass()->createTemplate([
            "name" => $name,
            "items" => $items,
        ]);
    }

    /**
     * 编辑
     *
     * @support  int $id id require false
     * @support  string $name 名称 require false
     * @support  array $update 更新数据 require false
     * @support  array $add 新增数据 require false
     * @support  array $delete 删除数据 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTemplate () {
        return self::getClass()->updateTemplate();
    }

    /**
     * 删除模版
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteTemplate () {
        return self::getClass()->deleteTemplate();
    }

    /**
     * 模版列表
     *
     * @support  string $name 名称 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplateList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getTemplateList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 模版详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplateDetail () {
        return self::getClass()->getTemplateDetail();
    }

    /**
     * 根据模版名称获取id
     *
     * @support  string $name 模版名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getTemplateIdByName () {
        return self::getClass()->getTemplateIdByName();
    }

    /**
     * 创建评分项
     *
     * @support  int $satisfaction_id 项目ID [ require true ]
     * @support  int $template_id 模版ID [ require true ]
     * @support  array $scores 打分项 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createTemplateScore () {
        return self::getClass()->createTemplateScore();
    }

    /**
     * 删除评分项
     *
     * @support  int $satisfaction_id 项目ID [ require true ]
     * @support  int $template_id 模版ID [ require true ]
     * @support  int $id 评分项ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteTemplateScore () {
        return self::getClass()->deleteTemplateScore();
    }

    /**
     * 评分项列表
     *
     * @support  int $satisfaction_id 项目ID [ require true ]
     * @support  int $template_id 模版ID [ require true ]
     * @support  int $to_id 被评人/部门 id [ require true ]
     * @support  string $type 被评人类型（&#039;staff&#039;,&#039;department&#039; [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplateScoreList () {
        return self::getClass()->getTemplateScoreList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Satisfaction\SatisfactionTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Satisfaction\SatisfactionTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}