<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method allCreatorByParams(array $params)
 * @method allByParams(array $params)
 * @method storedByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method startBatchByParams(array $params)
 * @method unSubmitNotifyByParams(array $params)
 * @method sendWorkNoticeByParams(array $params)
 */
class Inventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建盘点项目
     *
     * @param  string $name 盘点名称 [ require true ]
     * @param  string $type 盘点类型 [ require true ]
     * @support  array $configure 配置 
     * @throws  \Exception
     * @return  int
     */
    public static function create (string $name, string $type) {
        return self::getClass()->create([
            "name" => $name,
            "type" => $type,
        ]);
    }

    /**
     * 盘点创建人列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function allCreator () {
        return self::getClass()->allCreator();
    }

    /**
     * 盘点列表
     *
     * @param  int $staffId 创建人工号 [Original type uint] [ require true ]
     * @support  string $status 盘点状态 
     * @support  bool $with_count 统计盘点人数 
     * @support  string $type 盘点类型 
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $staffId = 0) {
        return self::getClass()->all([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 存档
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stored (int $inventory_id) {
        return self::getClass()->stored([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 修改盘点信息
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @support  string $name 盘点名称 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $inventory_id) {
        return self::getClass()->update([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 删除盘点项
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $inventory_id) {
        return self::getClass()->delete([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 一键开启评分
     *
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @support  array $to_staff_ids 员工id [Original type array&lt;uint&gt;] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function startBatch (int $inventory_id) {
        return self::getClass()->startBatch([
            "inventory_id" => $inventory_id,
        ]);
    }

    /**
     * 未评分通知
     *
     * @param  array $from_staff_ids 员工id [Original type array&lt;uint&gt;] [ require true ]
     * @param  int $inventory_id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unSubmitNotify (int $inventory_id, array $from_staff_ids = []) {
        return self::getClass()->unSubmitNotify([
            "inventory_id" => $inventory_id,
            "from_staff_ids" => $from_staff_ids,
        ]);
    }

    /**
     * 发送评分会议通知
     *
     * @param  array $data data [ require true ]
     * @param  string $title 标题 [ require true ]
     * @param  bool $change 是否有更改提示 [ require true ]
     * @param  array $onlyStaffIds 只发送指定伙伴 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWorkNotice (array $data, string $title, bool $change, array $onlyStaffIds = []) {
        return self::getClass()->sendWorkNotice([
            "data" => $data,
            "title" => $title,
            "change" => $change,
            "onlyStaffIds" => $onlyStaffIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Inventory\Inventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Inventory\Inventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}