<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method departmentTreeByParams(array $params)
 * @method allByParams(array $params)
 */
class Department {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询部门信息-返回部门基础信息和部门父级信息
     *
     * @param  array $department_ids 部门ids [Original type array&lt;uint&gt;] [ require true ]
     * @param  bool $with_parent_info 含父级信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (array $department_ids, bool $with_parent_info = false) {
        return self::getClass()->detail([
            "department_ids" => $department_ids,
            "with_parent_info" => $with_parent_info,
        ]);
    }

    /**
     * 部门树结构
     *
     * @throws  \Exception
     * @return  array
     */
    public static function departmentTree () {
        return self::getClass()->departmentTree();
    }

    /**
     * 部门all
     *
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Department');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Department');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}