<?php
namespace Mainto\Bridge\Invokes\OaProject\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getFamilyStaffListByParams(array $params)
 * @method getStoreStaffByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getFamilyStaffList
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFamilyStaffList () {
        return self::getClass()->getFamilyStaffList();
    }

    /**
     * 获取管辖门店的伙伴列表
     *
     * @param  bool $with_dept 是否返回部门 [ require true ]
     * @support  string $name 姓名 
     * @support  string $nickname 花名 
     * @support  int $staff_id 工号 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreStaff (bool $with_dept = false) {
        return self::getClass()->getStoreStaff([
            "with_dept" => $with_dept,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Common\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Common\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}