<?php
namespace Mainto\Bridge\Invokes\OaProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method adoptByParams(array $params)
 * @method ignoreByParams(array $params)
 * @method replayByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method typeListByParams(array $params)
 * @method statusListByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class Feedback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 采纳
     *
     * @param  int $id 反馈记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function adopt (int $id) {
        return self::getClass()->adopt([
            "id" => $id,
        ]);
    }

    /**
     * 忽略
     *
     * @param  int $id 反馈记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function ignore (int $id) {
        return self::getClass()->ignore([
            "id" => $id,
        ]);
    }

    /**
     * 回复
     *
     * @param  int $id 反馈记录id [Original type uint] [ require true ]
     * @param  string $replay_content 回复内容 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function replay (int $id, string $replay_content) {
        return self::getClass()->replay([
            "id" => $id,
            "replay_content" => $replay_content,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $type 反馈类型 
     * @support  string $status 反馈标记 
     * @support  string $content 反馈内容 
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $page_size = 10) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取反馈详情
     *
     * @param  int $id 反馈记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 反馈类型列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function typeList () {
        return self::getClass()->typeList();
    }

    /**
     * 标记状态列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function statusList () {
        return self::getClass()->statusList();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 获取导出详情接口
     *
     * @param  string $task_id 任务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (string $task_id) {
        return self::getClass()->getInfo([
            "task_id" => $task_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('OaProject', 'Manage\Feedback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('OaProject', 'Manage\Feedback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}